/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.model;

import com.cku.oa.show.entity.ShowResults;
import com.cku.oa.show.entity.ShowScore;
import com.cku.oa.show.entity.ShowScoreRanking;

/**
 * 赛事积分Entity
 *
 * @author lgl
 * @version 2016-07-12
 */
public class CkuShowScore {
	private String score; // 积分
	private String pedigreeCertified; // 血统证书编号
	private String dogOwner; // 犬主人
	private String dogBreedNameCn; // 犬种中文名
	private String dogBreedNameEn; // 犬种英文名
	private String dogName; // 犬名
	private String kennlCnName;//
	private String kennlEnName;//
	private String scoreType;//
	private String scoreTitle;//
	
	private int ranking;		// 排名
	
	private String dogPhoto;		// 犬只照片
	private String trend;		// 上升趋势 0持平 1上升 2下降
	private String dogBreedGroup;		// 犬种组
	private String dogBreed;		// 犬种
	private String year;
	public String getYear() {
		return year;
	}
	public void setYear(String year) {
		this.year = year;
	}
	public String getDogBreedGroup() {
		return dogBreedGroup;
	}
	public void setDogBreedGroup(String dogBreedGroup) {
		this.dogBreedGroup = dogBreedGroup;
	}
	public String getDogBreed() {
		return dogBreed;
	}
	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
	public String getDogPhoto() {
		return dogPhoto;
	}
	public void setDogPhoto(String dogPhoto) {
		this.dogPhoto = dogPhoto;
	}
	public String getTrend() {
		return trend;
	}
	public void setTrend(String trend) {
		this.trend = trend;
	}
	public int getRanking() {
		return ranking;
	}
	public void setRanking(int ranking) {
		this.ranking = ranking;
	}

	public CkuShowScore(ShowScore showScore){
		this.score = showScore.getScore();
		this.pedigreeCertified = showScore.getPedigreeCertified();
		this.dogOwner = showScore.getDogOwner();
		this.dogBreedNameCn = showScore.getDogBreedNameCn();
		this.dogBreedNameEn = showScore.getDogBreedNameEn();
		this.dogName = showScore.getDogName();
		this.scoreType = showScore.getScoreType();
	}
	public CkuShowScore(ShowResults showResult){
		this.score = showResult.getScore();
		this.pedigreeCertified = showResult.getPedigreeCertified();
		this.dogOwner = showResult.getDogOwnerNameCn();
		this.dogBreedNameCn = showResult.getBreedCnName();
		this.dogBreedNameEn = showResult.getBreedEnName();
		this.dogName = showResult.getDogName();
		this.kennlCnName = showResult.getKennlCnName();
		this.kennlEnName = showResult.getKennlEnName();
		this.scoreType = showResult.getScoreType();
	}
	
	public CkuShowScore(ShowScoreRanking showScoreRanking){
		this.score = showScoreRanking.getScore().toString().split("\\.")[0];
		this.pedigreeCertified = showScoreRanking.getPedigreeCertified();
		this.dogOwner = showScoreRanking.getDogOwner();
		this.dogBreedNameCn = showScoreRanking.getDogBreedNameCn();
		this.dogBreedNameEn = showScoreRanking.getDogBreedNameEn();
		this.dogName = showScoreRanking.getDogName();
		this.scoreType = showScoreRanking.getScoreType();
		this.kennlCnName = showScoreRanking.getKennlCnName();
		this.kennlEnName = showScoreRanking.getKennlEnName();
		this.trend = showScoreRanking.getTrend();
		this.dogBreedGroup = showScoreRanking.getDogBreedGroup();
		this.dogBreed = showScoreRanking.getDogBreed();
		this.year = showScoreRanking.getYear();
	}

	public String getScoreTitle() {
		return scoreTitle;
	}

	public void setScoreTitle(String scoreTitle) {
		this.scoreTitle = scoreTitle;
	}

	public String getScoreType() {
		return scoreType;
	}

	public void setScoreType(String scoreType) {
		this.scoreType = scoreType;
	}

	public String getKennlCnName() {
		return kennlCnName;
	}

	public void setKennlCnName(String kennlCnName) {
		this.kennlCnName = kennlCnName;
	}

	public String getKennlEnName() {
		return kennlEnName;
	}

	public void setKennlEnName(String kennlEnName) {
		this.kennlEnName = kennlEnName;
	}

	public String getScore() {
		return score;
	}

	public void setScore(String score) {
		this.score = score;
	}

	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}

	public String getDogBreedNameCn() {
		return dogBreedNameCn;
	}

	public void setDogBreedNameCn(String dogBreedNameCn) {
		this.dogBreedNameCn = dogBreedNameCn;
	}

	public String getDogBreedNameEn() {
		return dogBreedNameEn;
	}

	public void setDogBreedNameEn(String dogBreedNameEn) {
		this.dogBreedNameEn = dogBreedNameEn;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}
}