package com.cku.restful.v1.oauth.web;

import com.alibaba.druid.util.StringUtils;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.restful.v1.oauth.service.OAuth2ClientServiceImpl;
import com.cku.restful.v1.oauth.service.OAuthServiceImpl;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.request.OAuthAuthzRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.error.OAuthError;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * Created by user on 2016/4/27.
 */
@Controller
@RequestMapping("oauth2")
public class Oauth2AuthorizeController {
    @Autowired
    private OAuthServiceImpl oAuthService;
    @Autowired
    private OAuth2ClientServiceImpl oAuth2ClientService;
    @Autowired
    UserService userService;

    @RequestMapping("authorize")
    public Object authorize(Model model,HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        ModelAndView mav = new ModelAndView();
//		String username, String webKey, String scope, String state,String display
        //构建OAuth请求
        OAuthAuthzRequest oAuthzRequest = new OAuthAuthzRequest(request);
        //获取OAuth客户端Id
        String clientId = oAuthzRequest.getClientId();
        //校验客户端Id是否正确
        if(!oAuthService.checkClientId(clientId)){
            OAuthResponse oAuthResponse = OAuthASResponse
                    .errorResponse(HttpServletResponse.SC_BAD_REQUEST)
                    .setError(OAuthError.TokenResponse.INVALID_CLIENT)
                    .setErrorDescription("无效的客户端Id")
                    .buildJSONMessage();
			return new ResponseEntity(oAuthResponse.getBody(), HttpStatus.valueOf(oAuthResponse.getResponseStatus()));
        }
        //用户信息
        String userInfo = "";
        //TODO 跳转登录页面
        Subject subject = SecurityUtils.getSubject();  
        if(!subject.isAuthenticated()) {  
        	String username = request.getParameter("username");
            String password = request.getParameter("password");
            try{
            	userService.oauthLogin(username, password, IPLimitUtil.getIpAddr(request), clientId);
            }catch(Exception e){
            	//登录失败时跳转到登陆页面  
            	model.addAttribute("client",      
              		  oAuth2ClientService.selectByClientId(oAuthzRequest.getClientId()));  
                return "oauth2login"; 
            }
       } 
       
        Member member = UserUtils.getLoginMember();
        JSONObject object = new JSONObject();
        object.put("username", member.getName());
        object.put("email", member.getEmail());
        if(member.getKennel() == null||StringUtils.isEmpty(member.getKennel().getId())){
        	object.put("isKennel", false);
        }else{
        	object.put("isKennel", true);
        }
        User user = UserUtils.getLoginUser();
        object.put("openId",user.getId());
        userInfo = object.toString();
        
        //生成授权码
        String authCode = null;
        String responseType = oAuthzRequest.getParam(OAuth.OAUTH_RESPONSE_TYPE);
        //ResponseType仅支持CODE和TOKEN
        if(responseType.equals(ResponseType.CODE.toString())){
            OAuthIssuerImpl oAuthIssuerImpl = new OAuthIssuerImpl(new MD5Generator());
            authCode = oAuthIssuerImpl.authorizationCode();
            oAuthService.addAuthCode(authCode, userInfo);
        }

        //构建OAuth响应
        OAuthASResponse.OAuthAuthorizationResponseBuilder builder = OAuthASResponse.authorizationResponse(request, HttpServletResponse.SC_FOUND);

        //设置授权码
        builder.setCode(authCode);

        //获取客户端重定向地址
        String redirectURI = oAuthzRequest.getParam(OAuth.OAUTH_REDIRECT_URI);

        //构建响应
        OAuthResponse response = builder.location(redirectURI).buildBodyMessage();
        //根据OAuthResponse返回ResponseEntity响应
        HttpHeaders headers = new HttpHeaders();
        try {
            headers.setLocation(new URI(response.getLocationUri()));
//			return new ResponseEntity<>(headers, HttpStatus.valueOf(response.getResponseStatus()));
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        mav.addObject(OAuth.OAUTH_CODE, authCode);
        mav.setViewName("redirect:"+redirectURI);
        return mav;
    }
    
    private boolean login(Subject subject, HttpServletRequest request) {  
	    if("get".equalsIgnoreCase(request.getMethod())) {  
	    	return false;  
	    }  
	    String username = request.getParameter("username");  
	    String password = request.getParameter("password");  
	  
	    if(StringUtils.isEmpty(username) || StringUtils.isEmpty(password)) {  
	    	return false;  
	    }  
	    UsernamePasswordToken token = new UsernamePasswordToken(username, password);  
	    try {  
	    	subject.login(token);  
	    	return true;  
	    } catch (Exception e) {  
	    	request.setAttribute("error", "登录失败:" + e.getClass().getName());  
	    	return false;  
	    }  
    }  
}
