package com.cku.restful.v1.gcWeb.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.joda.time.DateTime;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanshuai
 * @date 2023/1/30 16:09
 */
@Data
@ApiModel
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GCWebPageResponse implements Serializable {

	private static final long serialVersionUID = -4845089385179053818L;

	@ApiModelProperty("id")
	public String id;
	@ApiModelProperty("类型(1:关于2:讲座3:新闻4:合作机构5:友情链接6:考试大赛7:美容师人才库10:联系我们)")
	private Integer type;
	@ApiModelProperty("子类型（2::1美容讲座2:CKU专业培训,4::1:正式2:预备）")
	private Integer subType;
	@ApiModelProperty("标题")
	private String title;
	@ApiModelProperty("图片")
	private String image;
	@ApiModelProperty("缩略图")
	private String thumb;
	@ApiModelProperty("链接")
	private String url;
	@ApiModelProperty("内容")
	private String content;
	@ApiModelProperty("排序")
	private Integer sort;
	@ApiModelProperty("创建日期")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date createDate;
}
