/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dogNoseprin.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鼻纹抽奖结果Entity
 * 
 * @author xx
 * @version 2020-04-29
 */
public class DogNoseRaffleRecord extends DataEntity<DogNoseRaffleRecord> {

	private static final long serialVersionUID = 1L;
	private String memberCode; // 会员号
	private String memberName; // 会员名
	private String couponId; // 获奖优惠券ID
	private String couponName; // 获奖优惠券名称

	public DogNoseRaffleRecord() {
		super();
	}

	public DogNoseRaffleRecord(String id) {
		super(id);
	}

	@Length(min = 1, max = 60, message = "会员号长度必须介于 1 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 1, max = 60, message = "会员名长度必须介于 1 和 60 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 1, max = 60, message = "获奖优惠券ID长度必须介于 1 和 60 之间")
	public String getCouponId() {
		return couponId;
	}

	public void setCouponId(String couponId) {
		this.couponId = couponId;
	}

	@Length(min = 1, max = 60, message = "获奖优惠券名称长度必须介于 1 和 60 之间")
	public String getCouponName() {
		return couponName;
	}

	public void setCouponName(String couponName) {
		this.couponName = couponName;
	}

}