package com.cku.restful.v1.dog.web;

import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.oa.order.vo.GoldCertifiedBusinessVo;
import com.cku.restful.v1.dog.service.RestGoldCertifiedService;
import com.cku.restful.v1.dog.vo.request.GoldCertifiedApplyDetailRequest;
import com.cku.restful.v1.dog.vo.request.GoldCertifiedApplyRequest;
import com.cku.restful.v1.dog.vo.request.GoldCertifiedPageRequest;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedApplyDetailResp;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedPageResp;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 金质证书接口
 *
 * @author yuanshuai
 * @date 2023/6/7 17:38
 */
@Controller
@RequestMapping(value = "/api/v1/goldCertified")
@Api(tags = "金质证书接口")
public class RestGoldCertifiedController extends BaseRestController {

    @Autowired
    RestGoldCertifiedService restGoldCertifiedService;

    @ApiOperation(value = "列表")
    @GetMapping(value = "/list")
    @ResponseBody
    public PageResultDto<GoldCertifiedPageResp> findPage(@Valid GoldCertifiedPageRequest request) {
        BeanValidators.validateWithException(validator, request);
        Page<GoldCertifiedPageResp> respPage = restGoldCertifiedService.findPage(request);
        return PageResultDto.success(respPage.getList(), respPage.getCount());
    }

    @ApiOperation(value = "根据血统证书号或登记卡编号查询详情")
    @GetMapping(value = "/apply/detail")
    @ResponseBody
    public ResultDto<GoldCertifiedApplyDetailResp> findApplyDetailByDogCode(@Valid GoldCertifiedApplyDetailRequest request) {
        BeanValidators.validateWithException(validator, request);
        GoldCertifiedBusinessVo vo = restGoldCertifiedService.findAndValidateApplyDetailByDogCode(request, UserUtils.getLoginMember(), Boolean.TRUE);
        GoldCertifiedApplyDetailResp resp  = restGoldCertifiedService.generateDetailResp(vo);
        return ResultDto.success(resp);
    }

    @ApiOperation(value = "查看业务申请参数（此接口仅供查看申请参数）金质证书业务ID=3")
    @PostMapping(value = "/apply")
    @ResponseBody
    public ResultDto<String> apply(@RequestBody GoldCertifiedApplyRequest request) {
        return ResultDto.success("businessId=3");
    }
}
