package com.cku.partner.club.web;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.annotation.MultiSubmit;
import com.cku.core.RESTResponse;
import com.cku.oa.clubdog.entity.ClubDog;
import com.cku.oa.clubdog.service.ClubDogService;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.partner.club.service.DogClubService;
import com.cku.partner.club.service.PaymentService;
import com.cku.restful.v1.dog.service.RestDogColorMarkService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 淘宠宝犬只信息
 *user chaixueteng
 *2016年10月8日
 */
@Controller
@RequestMapping(value="/partner/clubDog")
public class DogClubController  extends BaseController{
	@Autowired
	public MemberService memberService;
	@Autowired
	private ClubDogService clubDogService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private PaymentService paymentService;
	@Autowired
	private DogClubService dogClubService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private RestDogColorMarkService restDogColorMarkService;
	
	@ModelAttribute
	public ClubDog get(@RequestParam(required=false) String id) {
		ClubDog entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = clubDogService.get(id);
		}
		if (entity == null){
			entity = new ClubDog();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(ClubDog clubDog, HttpServletRequest request, HttpServletResponse response, Model model) {
        User u = UserUtils.getLoginUser();
		clubDog.setCreateBy(u);
		Page<ClubDog> page = clubDogService.findPage(new Page<ClubDog>(request, response), clubDog); 
		model.addAttribute("page", page);
		return "partner/clubDog/clubDogList";
	}
	
	@RequestMapping(value = "form")
	public String form(ClubDog clubDog, Model model) {
	    model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
	    model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("clubDog", clubDog);
		return "partner/clubDog/clubDogForm";
	}
	
	@RequestMapping(value = "editForm")
	public String editForm(ClubDog clubDog, Model model) {
		model.addAttribute("clubDog", clubDog);
	    model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
	    model.addAttribute("dogBreedList", dogTypeService.findAllList());
		return "partner/clubDog/clubDogEditForm";
	}
	@RequestMapping(value = "viewForm")
	public String viewForm(ClubDog clubDog, Model model) {
		model.addAttribute("clubDog", clubDog);
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		return "partner/clubDog/clubDogViewForm";
	}

	@RequestMapping(value = "save")
	public String save(ClubDog clubDog, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, clubDog)){
			return form(clubDog, model);
		}
		if(StringUtils.isBlank(clubDog.getId())){//首次添加 
			String memberCode = clubDog.getMemberCode();
			Member member = memberService.getByMemberCode(memberCode);
			boolean b=false;
			if(member!=null){
				if(!MemberUtil.isActiveMember(member)){
					b=true;
				}
			}else{
				b=true;
			}
			if(b){
				clubDog.setDogBreed("");
				clubDog.setMemberCode("");
				clubDog.setDogOwner("");
				model.addAttribute("message", "新犬主无效!");
				return form(clubDog, model);
			}
			//验证出生日期
			boolean validate = validate(clubDog.getBirthdate());
			if(!validate){
				clubDog.setDogBreed("");
				clubDog.setMemberCode("");
				clubDog.setDogOwner("");
				clubDog.setBirthdate(null);
				model.addAttribute("message", "出生日期不低于60天!");
				return form(clubDog, model);
			}
			clubDogService.save(clubDog);
			PaymentOrder order = dogClubService.toOrder(clubDog);
			List<PaymentOrderDetail> payPage = dogClubService.toPayPage(order);
			model.addAttribute("orderId",order.getId());
			model.addAttribute("paymentOrderDetail", payPage);
			Org org = (Org) UserUtils.getSession().getAttribute("org");
			String id = org.getId();
			Org org2 = orgService.get(id);
			model.addAttribute("org", org2);
			return "partner/sys/clubDogPayPage";
		}else{//修改
			String memberCode = clubDog.getMemberCode();
			Member member = memberService.getByMemberCode(memberCode);
			boolean b=false;
			if(member!=null){
				if(!MemberUtil.isActiveMember(member)){
					b=true;
				}
			}else{
				b=true;
			}
			if(b){
				clubDog.setDogBreed("");
				clubDog.setMemberCode("");
				clubDog.setDogOwner("");
				model.addAttribute("message", "新犬主无效!");
				return editForm(clubDog, model);
			}
			clubDogService.save(clubDog);
		}
		addMessage(redirectAttributes, "保存犬只信息成功");
		return "redirect:/partner/clubDog/?repage";
	}
	
	public boolean validate(Date birthdate){
		int between_day = getDayBetween(new Date(), birthdate);
		if(between_day<60){
			return false;
		}else{
			return true;
		}
	}
	
	/**
	 *
	 * @description: 计算天数差
	 * @author: laiguanglong
	 * @date: 2016年8月15日 下午5:07:58
	 */
	private int getDayBetween(Date date, Date birthdate){
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		long between = dateCalendar.getTimeInMillis()-birthdateCalendar.getTimeInMillis();
		long between_day = between/(1000*3600*24);
		return (int)between_day;
	}
	
	/**
	 * 有订单直接进入订单页
	 * @Author chaixueteng
	 * @2017年10月13日下午2:11:17
	 */
	@RequestMapping(value = "paymentOrder")
	public String paymentOrder(ClubDog clubDog, Model model,RedirectAttributes redirectAttributes) {
		String runningNumber = clubDog.getRunningNumber();
		PaymentOrder order = paymentOrderService.getByOrderCode(runningNumber);
		if(order==null){
			 order = dogClubService.toOrder(clubDog);
		}else if("2".equals(order.getPaymentState())){//已缴费
			addMessage(redirectAttributes, "失败!订单已缴费");
			return "redirect:/partner/clubDog/?repage";
		}
		List<PaymentOrderDetail> payPage = dogClubService.toPayPage(order);
		model.addAttribute("orderId",order.getId());
		model.addAttribute("paymentOrderDetail", payPage);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String id = org.getId();
		Org org2 = orgService.get(id);
		model.addAttribute("org", org2);
		model.addAttribute("clubDog", clubDog);
		return "partner/sys/clubDogPayPage";
	}

	/**
	 * 鉴定证书支付页
	 * @Author chaixueteng
	 * @2016年10月18日上午9:33:15
	 */
	@MultiSubmit(timeout = 15)
	@RequestMapping(value="paymentClubOrder")
	public String paymentClubOrder(HttpServletRequest request,HttpServletResponse response,RedirectAttributes redirectAttributes){
		String paymentWay = request.getParameter("paymentWay");
		String orderId = request.getParameter("orderId");
		paymentService.updateOrderWay(orderId,paymentWay);
		PaymentOrder paymentOrder = paymentOrderService.get(orderId);
		if(paymentOrder==null){
			addMessage(redirectAttributes, "失败!订单已失效");
			return "redirect:/partner/clubDog/?repage";
		}else if("2".equals(paymentOrder.getPaymentState())){//已缴费
			addMessage(redirectAttributes, "失败!订单已缴费");
			return "redirect:/partner/clubDog/?repage";
		}
		if ("25".equals(paymentWay)) {//余额缴费
			paymentService.paymentClubOrder(paymentWay,orderId);
			return "redirect:/partner/clubDog/?repage";
		}else{
			return "redirect:/api/v1/open/alipay/pay/"+orderId;
		}
	}
	
	/**
	 * 打印鉴定证书
	 * @Author chaixueteng
	 * @2017年10月13日下午3:59:45
	 */
	@RequestMapping(value = "print")
	public String print(ClubDog clubDog, Model model) {
		model.addAttribute("clubDog", clubDog);
		clubDog.setPrintState("1");
		clubDog.setFirstPrint("1");
		clubDogService.save(clubDog);
	    model.addAttribute("dogColorMark", dogColorMarkService.getByDogColorMarkCode(clubDog.getColorFlag()).getDogColorMarkCn());
	    DogType byDogBreedCode = dogTypeService.getByDogBreedCode(clubDog.getDogBreed());
	    model.addAttribute("dogBreedCn",byDogBreedCode.getBreedCnName() );
	    model.addAttribute("dogBreedEn",byDogBreedCode.getBreedEnName() );
	    model.addAttribute("date",new Date());
		return "partner/clubDog/clubDogPrint";
	}
	/**
	 * 重置打印鉴定证书
	 * @Author chaixueteng
	 * @2017年10月13日下午3:59:45
	 */
	@RequestMapping(value = "restPrint")
	public String restPrint(ClubDog clubDog, Model model) {
		model.addAttribute("clubDog", clubDog);
		clubDog.setPrintState("0");
		clubDog.setFirstPrint("1");
		clubDogService.save(clubDog);
		return "redirect:/partner/clubDog/?repage";
	}
	
	/**
	 * 根据犬种选择毛色
	 * @Author chaixueteng
	 * @2017年10月17日下午3:23:52
	 */
	@RequestMapping(value = "/dogcolormark/getColormark", method = RequestMethod.GET)
	@ResponseBody
	public void dogcolormark(HttpServletRequest request,HttpServletResponse response) throws IOException {
		String dogBreed = request.getParameter("dogBreed");
		RESTResponse result = restDogColorMarkService.getList(dogBreed);
		ServletUtils.writeResponse(response, result);
	}
}
