package com.cku.oa.sys.service;

import java.util.List;

import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.sys.entity.SysUserLoginLog;
import com.cku.oa.sys.dao.SysUserLoginLogDao;

import javax.servlet.http.HttpServletRequest;

/**
 * 用户登录日志Service
 * @author yuanshuai
 * @version 2018-12-07
 */
@Service
@Transactional(readOnly = true)
public class SysUserLoginLogService extends CrudService<SysUserLoginLogDao, SysUserLoginLog> {

	public SysUserLoginLog get(String id) {
		return super.get(id);
	}
	
	public List<SysUserLoginLog> findList(SysUserLoginLog sysUserLoginLog) {
		return super.findList(sysUserLoginLog);
	}
	
	public Page<SysUserLoginLog> findPage(Page<SysUserLoginLog> page, SysUserLoginLog sysUserLoginLog) {
		return super.findPage(page, sysUserLoginLog);
	}
	
	@Transactional(readOnly = false)
	public void saveLoginLog(HttpServletRequest request) {
		SysUserLoginLog log = new SysUserLoginLog();
		log.setRemoteAddr(StringUtils.getRemoteAddr(request));
		log.setUserAgent(request.getHeader("user-agent"));
		super.save(log);
	}

	
}