package com.cku.oa.sys.entity.user;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonValue;

public interface IEnum<T extends Serializable> {

	@JsonValue
	T code();

	String message();

	static <T extends Serializable, E extends IEnum<T>> String getMessage(Class<E> enumClass, T code) {
		E orElse = codeOf(enumClass, code).orElse(null);
		return orElse == null ? null : orElse.message();
	}

	static <T extends Serializable, E extends IEnum<T>> String getMessage(Class<E> enumClass, T code,
			String defaultValue) {
		E orElse = codeOf(enumClass, code).orElse(null);
		return orElse == null ? defaultValue : orElse.message();
	}

	static <T extends Serializable, E extends IEnum<T>> Optional<E> codeOf(Class<E> enumClass, T code) {
		return Arrays.stream(enumClass.getEnumConstants()).filter((E e) -> {
			if (e == null) {
				return false;
			}
			if (e.code().getClass().equals(String.class)) {
				return e.code().equals(code);
			}
			if (e.code().getClass().equals(Integer.class)) {
				return e.code() == code;
			}
			throw new IllegalArgumentException("Type argument cannot be resolved");
		}).findAny();
	}

}