/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛事场馆Entity
 * @author 柴雪腾
 * @version 2017-08-02
 */
public class ShowVenue extends DataEntity<ShowVenue> {
	
	private static final long serialVersionUID = 1L;
	private String venueName;		// 举办地点
	private String venueAddress;		// 场馆地址
	private String venuePhone;		// 场馆电话
	private String venueInfo; //赛事地点
	private String venueLongitude;		//场馆经度
	private String venueLatitude; //场馆纬度

	public ShowVenue() {
		super();
	}

	public ShowVenue(String id){
		super(id);
	}

	@Length(min=0, max=50, message="举办地点长度必须介于 0 和 50 之间")
	public String getVenueName() {
		return venueName;
	}

	public void setVenueName(String venueName) {
		this.venueName = venueName;
	}
	
	
	public String getVenueAddress() {
		return venueAddress;
	}

	public void setVenueAddress(String venueAddress) {
		this.venueAddress = venueAddress;
	}
	
	@Length(min=0, max=20, message="场馆电话长度必须介于 0 和 20 之间")
	public String getVenuePhone() {
		return venuePhone;
	}

	public void setVenuePhone(String venuePhone) {
		this.venuePhone = venuePhone;
	}

	public String getVenueInfo() {
		return venueInfo;
	}

	public void setVenueInfo(String venueInfo) {
		this.venueInfo = venueInfo;
	}

	public String getVenueLongitude() {
		return venueLongitude;
	}

	public void setVenueLongitude(String venueLongitude) {
		this.venueLongitude = venueLongitude;
	}

	public String getVenueLatitude() {
		return venueLatitude;
	}

	public void setVenueLatitude(String venue_latitude) {
		this.venueLatitude = venue_latitude;
	}

}