package com.cku.oa.shop.web;

import com.cku.core.ZAException;
import com.cku.oa.shop.entity.ShopMember;
import com.cku.oa.shop.entity.ShopPayRecord;
import com.cku.oa.shop.service.ShopMemberService;
import com.cku.oa.shop.service.ShopPayRecordService;
import com.cku.oa.sys.entity.Org;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;

import net.sf.json.JSONObject;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.util.List;

/**
 * Created by user on 2016/8/15.
 */
@Controller
@RequestMapping(value = "${adminPath}/shop/shopMember")
public class ShopMemberController extends BaseController {
    @Autowired
    private ShopMemberService shopMemberService;
    @Autowired
    private ShopPayRecordService shopPayRecordService;

    /**
     * 俱乐部账户列表
     * @param shopMember
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("shop:shopMember:view")
    @RequestMapping(value = {"list", ""})
    public String list(ShopMember shopMember, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<ShopMember> page = shopMemberService.list(new Page<ShopMember>(request, response), shopMember);
        model.addAttribute("page", page);
        return "oa/shop/shopMemberList";
    }

    /**
     * 俱乐部账户详细
     * @param shopPayRecord
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("shop:shopMember:view")
    @RequestMapping(value = "detail")
    public String detail(ShopPayRecord shopPayRecord, HttpServletRequest request, HttpServletResponse response, Model model) {

        ShopMember shopMember = shopMemberService.getShopMemberByCode(shopPayRecord.getMemberCode());
        model.addAttribute("shopMember",shopMember);
        List<ShopPayRecord> list = shopPayRecordService.findList(shopPayRecord);
        model.addAttribute("list", list);
        return "oa/shop/shopMemberDetail";
    }

    /**
     * 俱乐部充值列表
     * @param shopPayRecord
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("shop:shopMember:view")
    @RequestMapping(value = "moneyList")
    public String moneyList(ShopPayRecord shopPayRecord, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<ShopPayRecord> page = shopPayRecordService.findPage(new Page<ShopPayRecord>(request, response), shopPayRecord);
        model.addAttribute("page", page);
        return "oa/shop/shopMemberMoneyList";
    }

    @RequiresPermissions("shop:shopMember:view")
    @RequestMapping(value = "refund")
    public String refund(ShopMember shopMember, HttpServletRequest request, HttpServletResponse response, Model model) {
        return "oa/shop/shopMemberRefund";
    }
    @RequiresPermissions("shop:shopMember:view")
    @RequestMapping(value = "form")
    public String form(ShopMember shopMember, HttpServletRequest request, HttpServletResponse response, Model model) {
        return "oa/shop/shopMemberForm";
    }
    /**
     * 俱乐部充值
     * @param shopMember
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("shop:shopMember:recharge")
    @RequestMapping(value = "recharge")
    public String recharge(ShopMember shopMember, HttpServletRequest request, HttpServletResponse response, Model model, RedirectAttributes redirectAttributes) {
        try {
            shopMemberService.recharge(shopMember);
        } catch (ZAException e) {
            addMessage(redirectAttributes, e.getMessage());
            return "redirect:"+ Global.getAdminPath()+"/shop/shopMember/form";
        }
        return "redirect:"+ Global.getAdminPath()+"/shop/shopMember/moneyList?repage";
    }
    /**
     * 俱乐部提现（退款）
     * @param shopMember
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("shop:shopMember:recharge")
    @RequestMapping(value = "charge")
    public String charge(ShopMember shopMember, HttpServletRequest request, HttpServletResponse response, Model model, RedirectAttributes redirectAttributes) {
        try {
            shopMemberService.charge(shopMember);
        } catch (ZAException e) {
            addMessage(redirectAttributes, e.getMessage());
            return "redirect:"+ Global.getAdminPath()+"/shop/shopMember/refund";
        }
        return "redirect:"+ Global.getAdminPath()+"/shop/shopMember/moneyList?repage";
    }

    @RequiresPermissions("shop:shopMember:view")
    @RequestMapping(value = "searchShopUser")
    @ResponseBody
    public String searchShopUser(String memberCode, HttpServletRequest request, HttpServletResponse response, Model model) {
        Org org = shopMemberService.searchShopUser(memberCode);
        JSONObject jo = new JSONObject();
        if(org!=null){
            jo.put("rc","0");
            jo.put("memberCode",org.getMemberCode());
            jo.put("memberName",org.getName());
            jo.put("contact",org.getContact());
            jo.put("shopMoney",org.getShopMoney());
        }else{
            jo.put("rc","-1");
            jo.put("org",null);
        }
        return jo.toString();
    }
}
