/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.groomer.dao.GroomerDiplomaDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.GroomerMemberService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.PinYinUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 美容师结业证书Service
 * 
 * @author cxt
 * @version 2016-07-15
 */
@Service
@Transactional(readOnly = true)
public class GroomerDiplomaService extends CrudService<GroomerDiplomaDao, GroomerDiploma> {
	@Autowired
	public RemindService remindService;
	@Autowired
	public GroomerMemberService groomerMemberService;
	@Autowired
	private ExpressQueueService expressQueueService;
	@Autowired
	private TrainingInstitutionService trainingInstitutionService;
	@Autowired
	private GroomerCourseService groomerCourseService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;

	public GroomerDiploma get(String id) {
		return super.get(id);
	}

	public List<GroomerDiploma> findList(GroomerDiploma groomerDiploma) {
		return super.findList(groomerDiploma);
	}

	public Page<GroomerDiploma> findPage(Page<GroomerDiploma> page, GroomerDiploma groomerDiploma) {
		return super.findPage(page, groomerDiploma);
	}

	@Transactional(readOnly = false)
	public void save(GroomerDiploma groomerDiploma) {
		if (groomerDiploma.getIsNewRecord()) {
			// 保存操作
			String memberCode = groomerDiploma.getMemberCode();
			Member member = memberService.getByMemberCode(memberCode);
			if (!((member.getMemberEndDate() != null && member.getMemberEndDate().getTime() >= new Date().getTime())
					|| (member.getGroomerEndDate() != null
							&& member.getGroomerEndDate().getTime() >= new Date().getTime()))) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员不是CKU有效会员");
			}
			groomerDiploma.setPaymentState("1");
			groomerDiploma.setPaymentTime(null);
			groomerDiploma.setReviewer(null);
			groomerDiploma.setReviewState("0");
			groomerDiploma.setReviewTime(null);
			groomerDiploma.setProccessState("0");
			groomerDiploma.setProccessTime(null);
			groomerDiploma.setPrintState("0");
			String schoolId = groomerDiploma.getSchoolId();
			TrainingInstitution ti = trainingInstitutionService.get(schoolId);
			groomerDiploma.setSchoolNameCn(ti.getSchoolNameCn());
			groomerDiploma.setSchoolNameEn(ti.getSchoolNameEn());
		}
		super.save(groomerDiploma);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerDiploma groomerDiploma) {
		super.delete(groomerDiploma);
	}

	@Transactional(readOnly = false)
	public void review(GroomerDiploma gd) throws ZAException {
		try {
			String id = gd.getId();
			String reviewRemarks = gd.getReviewRemarks();
			GroomerDiploma groomerDiploma = super.get(id);
			String memberCode = groomerDiploma.getMemberCode();
			String name = groomerDiploma.getName();
			SysContext sysContext = new SysContext(groomerDiploma.getPaymentState(), groomerDiploma.getReviewState(),
					groomerDiploma.getProccessState());
			groomerDiploma = new GroomerDiploma(id);
			if ("1".equals(gd.getReviewState())) {
				groomerDiploma.setReviewState("1");
				groomerDiploma.setReviewTime(new Date());
				sysContext.confirmSuccess(sysContext, "美容结业证书", groomerDiploma.getMemberCode(), "groomer_diploma",
						groomerDiploma.getId(), groomerDiploma.getRunningNumber(), (str) -> {
						});
				// 自2017-07-12日期学校端上线 下线此操作
				// 2020年1月7日15:59:40恢复此功能
				groomerMemberService.groomerUpdate(memberCode);
				remindService.addRemind("您提交的结业证书信息已经审核通过，可以进行打印制作。", memberCode);
				// TODO 财务收入确认时点
				saPaymentDetailTotalService.financeConfirmTime(id, "groomer_diploma");
			} else if ("2".equals(gd.getReviewState())) {
				groomerDiploma.setReviewState("2");
				groomerDiploma.setReviewTime(new Date());
				groomerDiploma.setReviewRemarks(reviewRemarks);
				sysContext.confirmFail(sysContext, "美容结业证书", reviewRemarks, groomerDiploma.getMemberCode(),
						"groomer_diploma", groomerDiploma.getId(), groomerDiploma.getRunningNumber(), (str) -> {
						});
				remindService.addRemind("您提交的" + name + "学员的结业证书资料有误，请重新提交。", memberCode);
				System.out.println("您提交的" + name + "学员的结业证书资料有误，请重新提交。");
			}
			User user = UserUtils.getUser();
			if (StringUtils.isNotBlank(user.getName())) {
				groomerDiploma.setReviewer(user.getName());
			}
			dao.review(groomerDiploma);
		} catch (ZAException e) {
			throw e;
		}
	}

	@Transactional(readOnly = false)
	public void createCode(String id) {
		String[] ids = id.split(",");
		for (int i = 0; i < ids.length; i++) {
			GroomerDiploma groomerDiploma = super.get(ids[i]);
			String certificateCode = groomerDiploma.getCertificateCode();
			String paymentState = groomerDiploma.getPaymentState();
			String reviewState = groomerDiploma.getReviewState();
			if (StringUtils.isBlank(certificateCode) && "2".equals(paymentState) && "1".equals(reviewState)) {
				String level = groomerDiploma.getCertificateLevel();
				String schoolShortName = groomerDiploma.getTrainingInstitution().getSchoolShortName();
				GroomerDiploma gd = new GroomerDiploma();
				gd.setId(ids[i]);
				gd.setCertificateCode(SysCodeUtil.getGroomerDiplomaCode(schoolShortName, level));
				gd.setIssueDate(new Date());
				dao.createCode(gd);
			}
		}
	}

	/**
	 * 美容师结业证书导出
	 * 
	 * @throws IOException
	 * @Author chaixueteng
	 * @2016年8月3日下午6:36:22
	 */
	public void export(GroomerDiploma groomerDiploma, HttpServletResponse response) throws IOException {
		List<GroomerDiploma> diplomaList = dao.findList(groomerDiploma);
		for (GroomerDiploma gd : diplomaList) {
			gd.setSchoolNameCn(gd.getSchoolNameCn());
			gd.setCertificateLevel("美容师" + gd.getCertificateLevel() + "级");
		}
		new ExportExcel("", GroomerDiploma.class, 2).setDataList(diplomaList).write(response, "美容师结业证书.xlsx").dispose();
	}

	/**
	 * 批量审核通过
	 * 
	 * @Author chaixueteng
	 * @2016年8月4日上午10:51:28
	 */
	@Transactional(readOnly = false)
	public void listSubmit(String id) {
		String[] ids = id.split(",");
		GroomerDiploma gd = new GroomerDiploma();
		for (int i = 0; i < ids.length; i++) {
			GroomerDiploma groomerDiploma = dao.get(ids[i]);
			SysContext sysContext = new SysContext(groomerDiploma.getPaymentState(), groomerDiploma.getReviewState(),
					groomerDiploma.getProccessState());
			User user = UserUtils.getUser();
			if (StringUtils.isNotBlank(user.getName())) {
				gd.setReviewer(user.getName());
			}
			gd.setId(ids[i]);
			gd.setReviewState("1");
			gd.setReviewTime(new Date());
			sysContext.confirmSuccess(sysContext, "美容结业证书", groomerDiploma.getMemberCode(), "groomer_diploma",
					groomerDiploma.getId(), groomerDiploma.getRunningNumber(), (str) -> {
					});
			dao.review(gd);
			// groomerMemberService.groomerUpdate(memberCode);//自2017-07-12日期学校端上线 下线此操作
		}
	}

	/**
	 * 重置打印
	 * 
	 * @Author chaixueteng
	 * @2016年8月22日下午5:50:38
	 */
	@Transactional(readOnly = false)
	public void resetPrint(String id) {
		GroomerDiploma groomerDiploma = super.get(id);
		groomerDiploma.setPrintState("0");
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "美容师结业证书重置打印", groomerDiploma.getMemberCode(), "groomer_diploma",
				groomerDiploma.getId(), groomerDiploma.getRunningNumber(), (str) -> {
				});
		dao.resetPrint(groomerDiploma);
	}

	/**
	 * 首页 获取已缴费 未审核的结业证书
	 * 
	 * @Author chaixueteng
	 * @2016年8月30日下午5:42:46
	 */
	public int getAuditCount() {
		GroomerDiploma groomerDiploma = new GroomerDiploma();
		groomerDiploma.setPaymentState("2");
		groomerDiploma.setReviewState("0");
		return dao.getAuditCount(groomerDiploma);
	}

	/**
	 * 打印
	 * 
	 * @Author chaixueteng
	 * @2016年9月3日下午4:23:03
	 */
	@Transactional(readOnly = false)
	public GroomerDiploma print(GroomerDiploma groomerDiploma) {
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "美容师结业证书打印", groomerDiploma.getMemberCode(), "groomer_diploma",
				groomerDiploma.getId(), groomerDiploma.getRunningNumber(), (str) -> {
				});
		groomerDiploma.setPrintState("1");
		dao.resetPrint(groomerDiploma);
		// 推送打印消息
		expressQueueService.push(groomerDiploma.getMemberCode(), groomerDiploma.getRunningNumber(), "美容师结业证书",
				groomerDiploma.getCertificateCode(), "29"); // GYH1 modified
		Date issueDate = groomerDiploma.getIssueDate();
		String date = DateUtils.formatDate(issueDate, "yyyy年M月d日");
		// 英文名
		Member member = memberService.getByMemberCode(groomerDiploma.getMemberCode());
		groomerDiploma.setNameEn(!Objects.isNull(member) && StringUtils.isNotBlank(member.getNameEn())
				? member.getNameEn()
				: PinYinUtil.getFullSpell(groomerDiploma.getName()));
		groomerDiploma.setIssDate(date);
		return groomerDiploma;
	}

	/**
	 *
	 * @description: 美容师业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月19日 上午10:11:23
	 */
	public void validateBusiness(GroomerDiploma po) {
		// 校验重复订单
		GroomerDiploma example = new GroomerDiploma();
		example.setMemberCode(po.getMemberCode());
		List<GroomerDiploma> list = findList(example);
		if (list.size() != 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员已申请美容师结业证明");
		}
	}

	/**
	 * 批量添加结业记录(合作学校)
	 * 
	 * @Author chaixueteng
	 * @2017年6月22日下午7:31:57
	 */
	@Transactional(readOnly = false)
	public void batchSave(GroomerDiploma groomerDiploma, String[] studentNo) {
		String groomerCourseId = groomerDiploma.getGroomerCourseId();
		String schoolId = groomerDiploma.getSchoolId();
		String schoolNameCn = groomerDiploma.getSchoolNameCn();
		String schoolNameEn = groomerDiploma.getSchoolNameEn();
		GroomerCourse gc = groomerCourseService.get(groomerCourseId);
		for (int i = 0; i < studentNo.length; i++) {
			GroomerDiploma gd = new GroomerDiploma();
			Member byMemberCode = memberService.getByMemberCode(studentNo[i]);
			gd.setMemberCode(studentNo[i]);
			gd.setGroomerCourseId(groomerCourseId);
			gd.setName(byMemberCode.getName());
			gd.setStartDate(gc.getStartDate());
			gd.setCertificateLevel(gc.getDiplomaLevel());
			;
			gd.setEndDate(gc.getEndDate());
			gd.setTeacher(gc.getTeacher());
			gd.setSchoolId(schoolId);
			gd.setPaymentState("1");
			gd.setPaymentTime(null);
			gd.setReviewer(null);
			gd.setReviewState("0");
			gd.setReviewTime(null);
			gd.setProccessState("0");
			gd.setProccessTime(null);
			gd.setPrintState("0");
			gd.setSchoolNameCn(schoolNameCn);
			gd.setSchoolNameEn(schoolNameEn);
			this.save(gd);
		}

	}

	/**
	 * 单条添加结业记录(合作学校)
	 * 
	 * @Author chaixueteng
	 * @2017年6月22日下午7:31:57
	 */
	@Transactional(readOnly = false)
	public void diplomaSave(GroomerDiploma groomerDiploma, String avatar) {
		GroomerDiploma search = new GroomerDiploma();
		search.setMemberCode(groomerDiploma.getMemberCode());
		search.setCertificateLevel(groomerDiploma.getCertificateLevel());
		search.setSchoolId(groomerDiploma.getSchoolId());
		List<GroomerDiploma> list = findList(search);
		if (list.size() > 1) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员已有同级别同学校结业记录了");
		}
		GroomerCourse gc = groomerCourseService.get(groomerDiploma.getGroomerCourseId());
		GroomerDiploma gd = new GroomerDiploma();
		Member member = memberService.getByMemberCode(groomerDiploma.getMemberCode());
		if ("1".equals(member.getFreezeFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员已冻结!");
		}
		gd.setMemberCode(groomerDiploma.getMemberCode());
		gd.setGroomerCourseId(groomerDiploma.getGroomerCourseId());
		gd.setName(member.getName());
		gd.setStartDate(gc.getStartDate());
		gd.setCertificateLevel(gc.getDiplomaLevel());
		;
		gd.setEndDate(gc.getEndDate());
		gd.setTeacher(gc.getTeacher());
		gd.setSchoolId(groomerDiploma.getSchoolId());
		gd.setPaymentState("1");
		gd.setPaymentTime(null);
		gd.setReviewer(null);
		gd.setReviewState("0");
		gd.setReviewTime(null);
		gd.setProccessState("0");
		gd.setProccessTime(null);
		gd.setPrintState("0");
		gd.setSchoolNameCn(groomerDiploma.getSchoolNameCn());
		gd.setSchoolNameEn(groomerDiploma.getSchoolNameEn());
		this.save(gd);
		if (!avatar.equals(member.getAvatar())) {
			memberService.updateAvatar(avatar, member.getId());
		}
	}

	/**
	 * 是否有结业证书记录关联
	 * 
	 * @Author chaixueteng
	 * @2017年6月28日下午4:26:12
	 */
	public String haveDiploma(String id2) {
		GroomerDiploma gd = dao.haveDiploma(id2);
		if (gd == null) {
			return "true";
		} else {
			return "false";
		}
	}

	/**
	 * 合作学校编辑结业记录
	 * 
	 * @Author chaixueteng
	 * @2017年6月29日下午6:10:34
	 */
	@Transactional(readOnly = false)
	public void diplomaEditSave(GroomerDiploma groomerDiploma) {
		GroomerDiploma groomerDiploma2 = dao.get(groomerDiploma.getId());
		String groomerCourseId = groomerDiploma.getGroomerCourseId();
		GroomerCourse gc = groomerCourseService.get(groomerCourseId);
		groomerDiploma2.setGroomerCourseId(groomerDiploma.getGroomerCourseId());
		groomerDiploma2.setStartDate(gc.getStartDate());
		groomerDiploma2.setCertificateLevel(gc.getDiplomaLevel());
		;
		groomerDiploma2.setEndDate(gc.getEndDate());
		groomerDiploma2.setTeacher(gc.getTeacher());
		dao.update(groomerDiploma2);
	}

	public GroomerDiploma getDiplomaByMemberCode(String memberCode) {
		return dao.getByMemberCode(memberCode);
	}

}