/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 项目临时购物车Entity
 *
 * @author lyy
 * @version 2016-08-08
 */
public class PaymentProjectCart extends DataEntity<PaymentProjectCart> {

	private static final long serialVersionUID = 1L;
	private String projectId;        // 项目主键
	private String projectName;        // 订单项目名称
	private String memberCode;        // 会员号
	private String memberName;        // 会员名称
	private String chargingItemId;        // 收费项目主键
	private String chargingItemName;        //收费项目名称
	private String num;        // 数量
	private String price;        // 单价
	private String totalPrice;        // 总价
	private Date addTime;        // 添加时间
	private String businessOrderCode;        // 业务号
	private String voucherCode;        // 凭证号
	private String amount;

	private String businessId; //业务id
	private String businessName; //业务名称


	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	public PaymentProjectCart() {
		super();
	}

	public PaymentProjectCart(String id) {
		super(id);
	}

	public PaymentProjectCart(String projectId, String memberCode, String voucherCode) {
		this.projectId = projectId;
		this.memberCode = memberCode;
		this.voucherCode = voucherCode;
	}

	@Length(min = 0, max = 64, message = "项目主键长度必须介于 0 和 64 之间")
	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	@Length(min = 0, max = 100, message = "会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "收费项目主键长度必须介于 0 和 64 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	@Length(min = 0, max = 10, message = "数量长度必须介于 0 和 10 之间")
	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	@Length(min = 0, max = 200, message = "凭证号长度必须介于 0 和 200 之间")
	public String getVoucherCode() {
		return voucherCode;
	}

	public void setVoucherCode(String voucherCode) {
		this.voucherCode = voucherCode;
	}

	@Length(min = 0, max = 100, message = "标识名称长度必须介于 0 和 100 之间")
	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	@Length(min = 0, max = 100, message = "会员名称长度必须介于 0 和 100 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 0, max = 100, message = "项目名称长度必须介于 0 和 100 之间")
	public String getChargingItemName() {
		return chargingItemName;
	}

	public void setChargingItemName(String chargingItemName) {
		this.chargingItemName = chargingItemName;
	}

	public String getBusinessOrderCode() {
		return businessOrderCode;
	}

	public void setBusinessOrderCode(String businessOrderCode) {
		this.businessOrderCode = businessOrderCode;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}
}