package com.cku.oa.dog.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogSemenChangeDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.entity.DogSemenChange;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只精子变更Service
 *
 * @author lgl
 * @version 2017-08-29
 */
@Service
@Transactional(readOnly = true)
public class DogSemenChangeService extends CrudService<DogSemenChangeDao, DogSemenChange> {

    @Autowired
    private MemberService memberService;
    @Autowired
    private DogSemenDao dogSemenDao;
    @Autowired
    private DogDao dogDao;
    @Autowired
    private LoginServerService loginServerService;
    @Autowired
    private SaPaymentDetailTotalService saPaymentDetailTotalService;

    public DogSemenChange get(String id) {
        return super.get(id);
    }

    public List<DogSemenChange> findList(DogSemenChange dogSemenChange) {
    	if(StringUtils.isBlank(dogSemenChange.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogSemenChange.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogSemenChange.getSqlMap().put("dogBreedMap", " ='"+dogSemenChange.getDogBreed()+"'");
    	}
    	return super.findList(dogSemenChange);
    }

    public Page<DogSemenChange> findPage(Page<DogSemenChange> page, DogSemenChange dogSemenChange) {
    	if(StringUtils.isBlank(dogSemenChange.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogSemenChange.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogSemenChange.getSqlMap().put("dogBreedMap", " ='"+dogSemenChange.getDogBreed()+"'");
    	}
    	return super.findPage(page, dogSemenChange);
    }

    @Transactional(readOnly = false)
    public void save(DogSemenChange dogSemenChange) {
        super.save(dogSemenChange);
    }

    @Transactional(readOnly = false)
    public void delete(DogSemenChange dogSemenChange) {
        super.delete(dogSemenChange);
    }

    public void validateBusiness(DogSemenChange po) {
        if (po.getNewMemberCode().equals(po.getOriginMemberCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只精子已经在您的名下");
        }
        Member newMember = memberService.getByMemberCode(po.getNewMemberCode());
        Member originMember = memberService.getByMemberCode(po.getOriginMemberCode());
        checkMember(newMember,originMember);
    }

    public void checkMember(Member newMember,Member originMember) {
        //1、	申请人为CKU有效专业会员
        if (!MemberUtil.isActiveMember(newMember) || !"professional".equals(newMember.getMemberType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新精子主人必须是有效专业会员");
        }
        //1、	原精子主人为CKU有效专业会员
        if (!MemberUtil.isActiveMember(originMember) || !"professional".equals(originMember.getMemberType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "原精子主人必须是有效专业会员");
        }
    }

    /**
     * @description: 原精子主人审核
     * @author: laiguanglong
     * @date: 2017/8/30 10:54
     */
    @Transactional(readOnly = false)
    public void originMemberAudit(DogSemenChange vo) {
        DogSemenChange po = get(vo.getId());
        if (!po.getOriginMemberCode().equals(UserUtils.getLoginMember().getMemberCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只精子变更记录id有误");
        }
        if (!"2".equals(po.getPaymentState())
                || !"0".equals(po.getCkuReviewState())
                || !"0".equals(po.getProcessState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该记录不为已交费,协会未审核，且未处理，不允许审核");
        }
        //判断精子是否有被使用
        checkIsSemenUse(po);
        dao.originMemberAudit(vo);
    }

    /**
     * @description: 协会审核
     * @author: laiguanglong
     * @date: 2017/8/30 10:54
     */
    @Transactional(readOnly = false)
    public void ckuAudit(DogSemenChange vo) {
        DogSemenChange po = get(vo.getId());
        if (!"2".equals(po.getPaymentState())
                || !"1".equals(po.getReviewState())
                || !"0".equals(po.getProcessState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该记录不为已交费，原主人审核通过,协会未审核，且未处理，不允许审核");
        }
        //判断精子是否有被使用
        checkIsSemenUse(po);
        dao.ckuAudit(vo);
    }

    /**
     * @description: 处理
     * @author: laiguanglong
     * @date: 2017/8/30 10:54
     */
    @Transactional(readOnly = false)
    public void resolve(DogSemenChange vo) {
        //处理前的判断
        if (!"2".equals(vo.getPaymentState())
                || !"1".equals(vo.getReviewState())
                || !"1".equals(vo.getCkuReviewState())
                || !"0".equals(vo.getProcessState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该记录不为已交费，原主人审核通过，新主人审核通过，且未处理，不允许处理");
        }
        Member newMember = memberService.getByMemberCode(vo.getNewMemberCode());
        Member originMember = memberService.getByMemberCode(vo.getOriginMemberCode());
        checkMember(newMember,originMember);
        //修改精子表主人信息
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("semenCode", vo.getSemenCode().split(","));
        map.put("memberCode", newMember.getMemberCode());
        map.put("memberName", newMember.getName());
        map.put("updateBy", UserUtils.getUser().getId());
        dao.resolve(map);
        //修改业务表状态
        vo.setProcessState("1");
        vo.setProcessTime(new Date());
        vo.preUpdate();
        dao.update(vo);
        // TODO 财务收入确认时点
        saPaymentDetailTotalService.financeConfirmTime(vo.getId(), "dog_semen_change");
    }

    public List<DogSemen> getDogSemenList(DogSemenChange po) {
        List<DogSemen> dogSemenList = Lists.newArrayList();
        if (po != null && StringUtils.isNotBlank(po.getSemenCode())) {
            for (String semenCode : po.getSemenCode().split(",")) {
                DogSemen dogSemen = dogSemenDao.getBySemenCode(semenCode);
                if (dogSemen != null) {
                    dogSemenList.add(dogSemen);
                }
            }
        }
        return dogSemenList;
    }

    public List<DogSemen> getAvailableDogSemen(String dogId, String memberCode) {
        return dogSemenDao.getAvailableDogSemenByDogIdAndMemberCode(dogId, memberCode);
    }

    public DogSemenChange buildPo(String[] ids, String newMemberCode) {
        HashMap<String, String> map = getSemenInfo(ids);
        DogSemenChange po = new DogSemenChange();
        Dog dog = dogDao.get(map.get("dogId"));
        po.setDogId(dog.getId());
        po.setPedigreeCertified(dog.getPedigreeCertifiedCode());
        po.setDogChip(dog.getIdentificationFlag());
        po.setDogBreed(dog.getDogBreed());
        po.setDogName(dog.getNameEn());
        Member originMember = memberService.getByMemberCode(map.get("memberCode"));
        po.setOriginMemberCode(originMember.getMemberCode());
        po.setOriginMemberName(originMember.getName());
        Member newMember = memberService.getByMemberCode(newMemberCode);
        po.setNewMemberCode(newMember.getMemberCode());
        po.setNewMemberName(newMember.getName());
        po.setSemenCode(map.get("semenCode"));
        return po;
    }

    public HashMap<String, String> getSemenInfo(String[] ids) {
        String memberCode = "";
        String dogId = "";
        StringBuilder semenCode = new StringBuilder();
        for (int i = 0, len = ids.length; i < len; i++) {
            DogSemen dogSemen = dogSemenDao.get(ids[i]);
            if (dogSemen == null
                    || "1".equals(dogSemen.getDelFlag())
                    || StringUtils.isNotBlank(dogSemen.getBreedCertifiedCode())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "精子id有误");
            }
            if (i == 0) {
                memberCode = dogSemen.getMemberCode();
                dogId = dogSemen.getDogId();
            } else {
                if (!memberCode.equals(dogSemen.getMemberCode())) {
                    throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请变更的精子必须属于同一个会员");
                }
                if (!dogId.equals(dogSemen.getDogId())) {
                    throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请变更的精子必须属于同一只犬");
                }
            }
            //查重
            if (isApply(dogSemen.getSemenCode())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "CKU精子编号" + dogSemen.getSemenCode() + "已被他人申请");
            }
            semenCode.append(dogSemen.getSemenCode()).append(",");
        }
        semenCode.deleteCharAt(semenCode.length() - 1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memberCode);
        map.put("dogId", dogId);
        map.put("semenCode", semenCode.toString());
        return map;
    }

    public boolean isApply(String semenCode) {
        if (dao.countUnFinishBySemenCode(semenCode) > 0) {
            return true;
        } else {
            return false;
        }
    }

    //判断精子是否有被使用
    public void checkIsSemenUse(DogSemenChange po){
        Map map = new HashMap<String,Object>();
        map.put("semenCode", po.getSemenCode().split(","));
        List<DogSemen> dogSemenList = dogSemenDao.getUsedDogSemen(map);
        if(dogSemenList.size()>0){
            StringBuilder sb = new StringBuilder();
            for(DogSemen dogSemen:dogSemenList){
                sb.append(dogSemen.getSemenCode()).append(",");
            }
            sb.deleteCharAt(sb.length()-1);
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "CKU精子编号" + sb.toString() + "已被使用，审核失败");
        }
    }

}