package com.cku.oa.dog.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogFrozenSemenDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogFrozenSemen;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.util.MemberUtil;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只冷冻精子Service
 *
 * @author lgl
 * @version 2017-08-24
 */
@Service
@Transactional(readOnly = true)
public class DogFrozenSemenService extends CrudService<DogFrozenSemenDao, DogFrozenSemen> {

    @Autowired
    public DogDao dogDao;
    @Autowired
    public DogDnaService dogDnaService;
    @Autowired
    public DogSemenDao dogSemenDao;
    @Autowired
    private BusinessBanService businessBanService;
    @Autowired
    private LoginServerService loginServerService;
    @Autowired
    private SaPaymentDetailTotalService saPaymentDetailTotalService;

    public DogFrozenSemen get(String id) {
        return super.get(id);
        
    }

    public List<DogFrozenSemen> findList(DogFrozenSemen dogFrozenSemen) {
    	if(StringUtils.isBlank(dogFrozenSemen.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogFrozenSemen.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogFrozenSemen.getSqlMap().put("dogBreedMap", " ='"+dogFrozenSemen.getDogBreed()+"'");
    	}
    	return super.findList(dogFrozenSemen);
    }

    public Page<DogFrozenSemen> findPage(Page<DogFrozenSemen> page, DogFrozenSemen dogFrozenSemen) {
    	if(StringUtils.isBlank(dogFrozenSemen.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogFrozenSemen.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogFrozenSemen.getSqlMap().put("dogBreedMap", " ='"+dogFrozenSemen.getDogBreed()+"'");
    	}
    	return super.findPage(page, dogFrozenSemen);
    }

    @Transactional(readOnly = false)
    public void save(DogFrozenSemen dogFrozenSemen) {
        super.save(dogFrozenSemen);
    }

    @Transactional(readOnly = false)
    public void delete(DogFrozenSemen dogFrozenSemen) {
        super.delete(dogFrozenSemen);
    }

    public void validateBusiness(DogFrozenSemen po) {
        Member member = UserUtils.getLoginMember();
        checkMember(member);
        Dog dog = dogDao.get(po.getDogId());
        checkDog(dog, member, po.getBusinessType());
    }

    public void checkMember(Member member) {
        //1、	申请人为CKU有效专业会员
        if (!MemberUtil.isActiveMember(member) || !"professional".equals(member.getMemberType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务仅限CKU有效专业会员办理");
        }
    }

    public void checkDog(Dog dog, Member member, String businessType) {
        if (!"1".equals(dog.getGender())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只性别不为公犬");
        }
        //申请犬只必须有位点分析记录
        if (!dogDnaService.isHaveDogDna(dog.getId())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬没有进行DNA存档");
        }
        //只能申请自己名下的犬只，不能代申请
        if ("0".equals(businessType) && !member.getMemberCode().equals(dog.getMemberCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只能申请自己名下的犬只，不能代申请");
        }
        //种犬申报,犬只芯片不能为空，否则提示“该犬只无芯片号，请先进行补植芯片
        if ("0".equals(businessType) && StringUtils.isBlank(dog.getIdentificationFlag())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只无芯片号，请先进行补植芯片");
        }
        //申报，犬只状态只能为正常
        if ("0".equals(businessType) && !"0".equals(dog.getDogState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬状态不为正常，不能申请种犬申报业务");
        }
        //报备，犬只状态只能为正常或注销
        if ("1".equals(businessType) && (!"0".equals(dog.getDogState()) && !"3".equals(dog.getDogState()))) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬状态不为正常或注销，不能申请种犬报备业务");
        }
        //业务禁止校验
        businessBanService.validateBusinessBan(dog, "该犬为禁止繁殖状态，无法办理该业务");
    }

    @Transactional(readOnly = false)
    public void audit0(DogFrozenSemen audit) {
        DogFrozenSemen po = dao.get(audit.getId());
        if (!"2".equals(po.getPaymentState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务记录未缴费。不允许操作");
        }
        po.setSemenNumber(audit.getOriginalSemenCode().size() + "");
        po.setReviewState(audit.getReviewState());
        Date now = new Date();
        po.setReviewTime(now);
        po.setAcquisitionTime(now);
        save(po);
        saveDogSemen(po, audit.getOriginalSemenCode());
        
        // TODO 财务收入确认时点
        saPaymentDetailTotalService.financeConfirmTime(po.getId(), "dog_frozen_semen");
    }

    @Transactional(readOnly = false)
    public void audit1(DogFrozenSemen audit) {
        DogFrozenSemen po = dao.get(audit.getId());
        if (!"2".equals(po.getPaymentState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务记录未缴费。不允许操作");
        }
        Date now = new Date();
        if ("1".equals(audit.getReviewState())) {
            auditPass(po, now);
            // TODO 财务收入确认时点
            saPaymentDetailTotalService.financeConfirmTime(po.getId(), "dog_frozen_semen");
        } else if ("2".equals(audit.getReviewState())) {
            po.setReviewState("2");
            po.setReviewTime(now);
            po.setReviewRemarks(audit.getReviewRemarks());
        }
        save(po);
    }

    public void auditPass(DogFrozenSemen po, Date now) {
        //1生成精子编号
        List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
        for (DogSemen dogSemen : dogSemenList) {
            dogSemen.setSemenCode(SysCodeUtil.getSemenCode());
            dogSemen.setAcquisitionTime(now);
            dogSemen.preUpdate();
            dogSemenDao.update(dogSemen);
        }
        //2修改业务表
        po.setAcquisitionTime(now);
        po.setReviewState("1");
        po.setReviewTime(now);
    }

    @Transactional(readOnly = false)
    public void edit0(DogFrozenSemen edit) {
        DogFrozenSemen po = dao.get(edit.getId());
        if (!"2".equals(po.getPaymentState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务记录未缴费。不允许操作");
        }
        if ("0".equals(edit.getReviewState())) {//还原至待处理状态
            //1冷冻精子业务表
            po.setSemenNumber(null);
            po.setReviewState("0");
            po.setAcquisitionTime(null);
            //2查标记原精子记录为删除
            dogSemenDao.deleteBySemenBatchCode(po.getSemenBatchCode());
        } else if ("1".equals(edit.getReviewState())) {
            //处理旧的
            HashMap<String, String> map = new HashMap<String, String>();
            if (StringUtils.isNotBlank(edit.getOld())) {
                String[] oldArray = edit.getOld().split(",");
                for (String old : oldArray) {
                    String[] array = old.split("=");
                    map.put(array[0], array[1]);
                }
            }
            List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
            for (DogSemen dogSemen : dogSemenList) {
                if (map.containsKey(dogSemen.getId())) {
                    String originalSemenCode = map.get(dogSemen.getId());
                    if (dogSemenDao.countByOriginalSemenCode(originalSemenCode, dogSemen.getId()) > 0) {
                        throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "原精子编号" + originalSemenCode + "已存在");
                    }
                    dogSemen.setOriginalSemenCode(originalSemenCode);
                    dogSemen.preUpdate();
                    dogSemenDao.update(dogSemen);
                } else {
                    dogSemenDao.delete(dogSemen);
                }
            }
            //添加新的
            List<Object> list = Lists.newArrayList();
            if (StringUtils.isNotBlank(edit.getNewadd())) {
                for (String originalSemenCode : edit.getNewadd().split(",")) {
                    list.add(originalSemenCode);
                }
                saveDogSemen(po, list);
            }
            //业务记录
            po.setSemenNumber(map.size() + list.size() + "");
            po.setAcquisitionTime(new Date());
        }
        save(po);
    }

    @Transactional(readOnly = false)
    public void edit1(DogFrozenSemen edit) {
        DogFrozenSemen po = dao.get(edit.getId());
        if (!"2".equals(po.getPaymentState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务记录未缴费。不允许操作");
        }
        Date now = new Date();
        if ("1".equals(po.getReviewState())) {
            if ("1".equals(edit.getReviewState())) {//通过改通过

            } else if ("2".equals(edit.getReviewState())) {//通过改不通过
                //还原数据1精子表，2业务表
                List<DogSemen> dogSemenList = dogSemenDao.getBySemenBatchCode(po.getSemenBatchCode());
                for (DogSemen dogSemen : dogSemenList) {
                    dogSemen.setSemenCode("");
                    dogSemen.setAcquisitionTime(null);
                    dogSemen.preUpdate();
                    dogSemenDao.update(dogSemen);
                }
                po.setReviewState("2");
                po.setReviewRemarks(edit.getReviewRemarks());
                po.setAcquisitionTime(null);
            }
        } else if ("2".equals(po.getReviewState())) {
            if ("1".equals(edit.getReviewState())) {//不通过改通过
                auditPass(po, now);
            } else if ("2".equals(edit.getReviewState())) {//不通过改不通过
                po.setReviewRemarks(edit.getReviewRemarks());
            }
        }
        po.setReviewTime(now);
        save(po);
    }

    //写入犬只精子表
    public void saveDogSemen(DogFrozenSemen po, List<Object> list) {
        for (int i = 0, len = list.size(); i < len; i++) {
            String originalSemenCode = (String) list.get(i);
            saveOneDogSemen(po, originalSemenCode);
        }
    }

    private DogSemen saveOneDogSemen(DogFrozenSemen dogFrozenSemen, String originalSemenCode) {
        if (dogSemenDao.countByOriginalSemenCode(originalSemenCode, null) > 0) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "原精子编号" + originalSemenCode + "已存在");
        }
        DogSemen po = new DogSemen();
        po.setDogId(dogFrozenSemen.getDogId());
        po.setPedigreeCertified(dogFrozenSemen.getPedigreeCertified());
        po.setDogChip(dogFrozenSemen.getDogChip());
        po.setDogBreed(dogFrozenSemen.getDogBreed());
        po.setDogName(dogFrozenSemen.getDogName());
        po.setSemenBatchCode(dogFrozenSemen.getSemenBatchCode());
        po.setMemberCode(dogFrozenSemen.getMemberCode());
        po.setMemberName(dogFrozenSemen.getMemberName());
        po.setOriginalSemenCode(originalSemenCode);
        if ("0".equals(dogFrozenSemen.getBusinessType())) {
            po.setSemenCode(SysCodeUtil.getSemenCode());
            po.setAcquisitionTime(dogFrozenSemen.getAcquisitionTime());
        }
        po.preInsert();
        dogSemenDao.insert(po);
        return po;
    }

    /**
     * @description: 删除犬只精子相关记录
     * @author: laiguanglong
     * @date: 2017/9/11 14:39
     */
    public void deleteDogSemen(String id) {
        DogFrozenSemen po = dao.get(id);
        if ("1".equals(po.getBusinessType())) {
            dogSemenDao.deleteBySemenBatchCode(po.getSemenBatchCode());
        }
    }

}