/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 出生证明Entity
 * @author lgl
 * @version 2016-08-04
 */
public class DogBirthCertificateApply extends DataEntity<DogBirthCertificateApply> {
	
	private static final long serialVersionUID = 1L;
	
	@NotBlank
	private String fmdogBreedCertifiedCode;		// 父母犬配犬证明号
	@NotNull
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date dogBirthday;		// 出生日期
	private String urgent;		// 是否加急
	private List<DogBirthCertificate> dogBirthCertificateList = Lists.newArrayList();		// 子表列表
	
	private String runningNumber;
	private String paymentChargingItemId;
	private String memberCode;
	
	private String sameBatchNum;		//同胎犬数格式为 x公y母		
	private String kennelName;		//犬舍名		
	
	public DogBirthCertificateApply(){
		
	}
	
	public DogBirthCertificateApply(String runningNumber,String paymentChargingItemId,String memberCode){
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.memberCode = memberCode;
	}
	
	public String getFmdogBreedCertifiedCode() {
		return fmdogBreedCertifiedCode;
	}
	public void setFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		this.fmdogBreedCertifiedCode = fmdogBreedCertifiedCode;
	}
	public Date getDogBirthday() {
		return dogBirthday;
	}
	public void setDogBirthday(Date dogBirthday) {
		this.dogBirthday = dogBirthday;
	}
	public String getUrgent() {
		return urgent;
	}
	public void setUrgent(String urgent) {
		this.urgent = urgent;
	}
	public List<DogBirthCertificate> getDogBirthCertificateList() {
		return dogBirthCertificateList;
	}
	public void setDogBirthCertificateList(
			List<DogBirthCertificate> dogBirthCertificateList) {
		this.dogBirthCertificateList = dogBirthCertificateList;
	}
	public String getRunningNumber() {
		return runningNumber;
	}
	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}
	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}
	public String getMemberCode() {
		return memberCode;
	}
	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getSameBatchNum() {
		return sameBatchNum;
	}

	public void setSameBatchNum(String sameBatchNum) {
		this.sameBatchNum = sameBatchNum;
	}

	public String getKennelName() {
		return kennelName;
	}

	public void setKennelName(String kennelName) {
		this.kennelName = kennelName;
	}
	
	
	
	
	
	
	
	
	
//	private String birthCerRegCode;		// 出生证明登记编号
//	private String pedigreeCertified;		// 血统证书号
//	private String dogOwenr;		// 犬主人
//	private String memberCode;		// 会员号
//	private String secondDogOwner;		// 第二犬主
//	private String secondOwnerMemberCode;		// 第二犬主会员号
//	private String breederMemberCode;		// 繁殖人会员号
//	private String breeder;		// 繁殖人
//	private String tempMemberCode;		// 临时会员号
//	private String tempUserName;		// 临时用户名
//	private String dogEnName;		// 英文姓名
//	private String dogGender;		// 性别
//	private String dogBreed;		// 种类
//	private String sameBatchNum;		// 同胎犬数
//	private String identificationFlag;		// 身份识别标志
//	private String colorFlag;		// 颜色及标志
//	private String dna;		// dna
//	private String fdogPedigreeCertified;		// 父犬血统证书号
//	private String mdogPedigreeCertified;		// 母犬血统证书号
//	private String operator;		// 操作人
//	private String price;		// 单价
//	private String deduction;		// 抵扣
//	private String addUser;		// 添加用户
//	private Date chipInjectDate;		// 芯片注入时间
//	private String snCode;		// 识别码
}