/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 犬只激活Entity
 *
 * @author lgl
 * @version 2018-06-12
 */
public class DogActivation extends DataEntity<DogActivation> {

    private static final long serialVersionUID = 1L;
    private String birthCode;        // 出生纸编号
    private String memberCode;        // 会员号
    private String price;        // 报价
    private String city;        // 犬只所在城市
    private String mobile;        // 电话
    private String linkman;        // 联系人
    private String frontPic;        // 正面照片
    private String sidePic;        // 侧面照片
    private String backPic;        // 背面照片
    private String lifePic;        // 生活照片
    private String healthInfo;        // 健康信息,json格式存储
    private String state;        // 上架状态：0未上架；1已上架
    private String consign;        // 是否寄售：0：否、1：是
    private Date addTime;        // 上架时间
    private String reviewState;        // 审核状态：未审核0；通过1；未通过2
    private Date reviewTime;        // 审核时间
    private String reviewRemarks;        // 审核的意见
    private String runningNumber;        // 流水号
    private String paymentState;        // 付款的状态：未支付1；已支付2
    private Date paymentTime;        // 付款时间
    private String orgId;
    private String frontPicReviewState;        // 正面照片审核状态：未审核0；通过1；未通过2
    private String sidePicReviewState;        // 正面照片审核状态：未审核0；通过1；未通过2
    private String backPicReviewState;        // 背面照片审核状态：未审核0；通过1；未通过2
    private String frontPicRemark;        // 正面照片审核备注
    private String sidePicRemark;        // 侧面照片审核备注
    private String backPicRemark;        // 背面照片审核备注
    private String identificationFlag;
    private Date beginCreateDate;        // 开始 create_date
    private Date endCreateDate;        // 结束 create_date
    private String cabPassport;        // 护照号
    private String dogBreed;        // 犬种号
    private String dogGender;        // 犬只性别
    private Date dogBirthday;        // 犬只生日
    private String upperReview;        // 上架审核状态
    private String type;        // 数据来源：1激活、2上架

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUpperReview() {
        return upperReview;
    }

    public void setUpperReview(String upperReview) {
        this.upperReview = upperReview;
    }

    public DogActivation() {
        super();
    }

    public String getConsign() {
        return consign;
    }

    public void setConsign(String consign) {
        this.consign = consign;
    }

    public String getCabPassport() {
        return cabPassport;
    }

    public void setCabPassport(String cabPassport) {
        this.cabPassport = cabPassport;
    }

    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

    public String getDogGender() {
        return dogGender;
    }

    public void setDogGender(String dogGender) {
        this.dogGender = dogGender;
    }

    public Date getDogBirthday() {
        return dogBirthday;
    }

    public void setDogBirthday(Date dogBirthday) {
        this.dogBirthday = dogBirthday;
    }

    public Date getBeginCreateDate() {
        return beginCreateDate;
    }

    public void setBeginCreateDate(Date beginCreateDate) {
        this.beginCreateDate = beginCreateDate;
    }

    public Date getEndCreateDate() {
        return endCreateDate;
    }

    public void setEndCreateDate(Date endCreateDate) {
        this.endCreateDate = endCreateDate;
    }

    public String getIdentificationFlag() {
        return identificationFlag;
    }

    public void setIdentificationFlag(String identificationFlag) {
        this.identificationFlag = identificationFlag;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getFrontPicReviewState() {
        return frontPicReviewState;
    }

    public void setFrontPicReviewState(String frontPicReviewState) {
        this.frontPicReviewState = frontPicReviewState;
    }

    public String getSidePicReviewState() {
        return sidePicReviewState;
    }

    public void setSidePicReviewState(String sidePicReviewState) {
        this.sidePicReviewState = sidePicReviewState;
    }

    public String getBackPicReviewState() {
        return backPicReviewState;
    }

    public void setBackPicReviewState(String backPicReviewState) {
        this.backPicReviewState = backPicReviewState;
    }

    public String getBackPicRemark() {
        return backPicRemark;
    }

    public void setBackPicRemark(String backPicRemark) {
        this.backPicRemark = backPicRemark;
    }

    public String getSidePicRemark() {
        return sidePicRemark;
    }

    public void setSidePicRemark(String sidePicRemark) {
        this.sidePicRemark = sidePicRemark;
    }

    public String getFrontPicRemark() {
        return frontPicRemark;
    }

    public void setFrontPicRemark(String frontPicRemark) {
        this.frontPicRemark = frontPicRemark;
    }

    public DogActivation(String id) {
        super(id);
    }

    @Length(min = 1, max = 20, message = "出生纸编号长度必须介于 1 和 20 之间")
    public String getBirthCode() {
        return birthCode;
    }

    public void setBirthCode(String birthCode) {
        this.birthCode = birthCode;
    }

    @Length(min = 1, max = 20, message = "会员号长度必须介于 1 和 20 之间")
    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    @Length(min = 0, max = 8, message = "报价长度必须介于 1 和 8 之间")
    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @Length(min = 1, max = 40, message = "犬只所在城市长度必须介于 1 和 40 之间")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Length(min = 1, max = 20, message = "电话长度必须介于 1 和 20 之间")
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Length(min = 1, max = 40, message = "联系人长度必须介于 1 和 40 之间")
    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    @Length(min = 1, max = 64, message = "正面照片长度必须介于 1 和 64 之间")
    public String getFrontPic() {
        return frontPic;
    }

    public void setFrontPic(String frontPic) {
        this.frontPic = frontPic;
    }

    @Length(min = 1, max = 64, message = "侧面照片长度必须介于 1 和 64 之间")
    public String getSidePic() {
        return sidePic;
    }

    public void setSidePic(String sidePic) {
        this.sidePic = sidePic;
    }

    @Length(min = 1, max = 64, message = "背面照片长度必须介于 1 和 64 之间")
    public String getBackPic() {
        return backPic;
    }

    public void setBackPic(String backPic) {
        this.backPic = backPic;
    }

    @Length(min = 1, max = 180, message = "生活照片长度必须介于 1 和 180 之间")
    public String getLifePic() {
        return lifePic;
    }

    public void setLifePic(String lifePic) {
        this.lifePic = lifePic;
    }

    @Length(min = 1, max = 1000, message = "健康信息,json格式存储长度必须介于 1 和 1000 之间")
    public String getHealthInfo() {
        return healthInfo;
    }

    public void setHealthInfo(String healthInfo) {
        this.healthInfo = healthInfo;
    }

    @Length(min = 1, max = 1, message = "上架状态：0未上架；1已上架长度必须介于 1 和 1 之间")
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    @Length(min = 1, max = 1, message = "审核状态：未审核0；通过1；未通过2长度必须介于 1 和 1 之间")
    public String getReviewState() {
        return reviewState;
    }

    public void setReviewState(String reviewState) {
        this.reviewState = reviewState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    @Length(min = 1, max = 100, message = "审核的意见长度必须介于 1 和 100 之间")
    public String getReviewRemarks() {
        return reviewRemarks;
    }

    public void setReviewRemarks(String reviewRemarks) {
        this.reviewRemarks = reviewRemarks;
    }

    @Length(min = 1, max = 50, message = "流水号长度必须介于 1 和 50 之间")
    public String getRunningNumber() {
        return runningNumber;
    }

    public void setRunningNumber(String runningNumber) {
        this.runningNumber = runningNumber;
    }

    @Length(min = 1, max = 1, message = "付款的状态：未支付1；已支付2长度必须介于 1 和 1 之间")
    public String getPaymentState() {
        return paymentState;
    }

    public void setPaymentState(String paymentState) {
        this.paymentState = paymentState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

}