/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogBreedCertified;
import com.cku.oa.dog.entity.DogBreedPrint;
import com.cku.oa.dog.entity.DogDna;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 繁育证书DAO接口
 * @author zhuoHeng
 * @version 2016-08-22
 */
@MyBatisDao
public interface DogBreedCertifiedDao extends CrudDao<DogBreedCertified> {
	
	int listCount(DogBreedCertified dogBreedCertified);

    void edit(DogBreedCertified dogBreedCertified);

    void changeProcessState(DogBreedCertified dogBreedCertified);
    
    DogBreedCertified getByDogId(String dogId);

    DogBreedPrint getPrintMessage(String fmdogBreedCertifiedCode);

    DogDna getDogDnaMessage(String dogId);

	void print(DogBreedCertified dogBreedCertified);

	void resetPrintState(DogBreedCertified dogBreedCertified);

	/**
	 * 
	 * @Description：繁育证书审核功能
	 * @author: zhuoHeng
	 * @version: 2016年10月11日 下午6:23:04
	 */
	void changeStatus(DogBreedCertified dogBreedCertified);
	
}