package com.cku.oa.contest.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.contest.entity.ContestJudgeTypeClass;
import com.cku.oa.contest.dao.ContestJudgeTypeClassDao;

/**
 * 赛制年龄组别对照Service
 * @author yuanshuai
 * @version 2020-11-05
 */
@Service
@Transactional(readOnly = true)
public class ContestJudgeTypeClassService extends CrudService<ContestJudgeTypeClassDao, ContestJudgeTypeClass> {

	public ContestJudgeTypeClass get(String id) {
		return super.get(id);
	}
	
	public List<ContestJudgeTypeClass> findList(ContestJudgeTypeClass contestJudgeTypeClass) {
		return super.findList(contestJudgeTypeClass);
	}
	
	public Page<ContestJudgeTypeClass> findPage(Page<ContestJudgeTypeClass> page, ContestJudgeTypeClass contestJudgeTypeClass) {
		return super.findPage(page, contestJudgeTypeClass);
	}
	
	@Transactional(readOnly = false)
	public void save(ContestJudgeTypeClass contestJudgeTypeClass) {
		super.save(contestJudgeTypeClass);
	}
	
	@Transactional(readOnly = false)
	public void delete(ContestJudgeTypeClass contestJudgeTypeClass) {
		super.delete(contestJudgeTypeClass);
	}

	public List<String> getJudgeTypeList() {
		return dao.getJudgeTypeList();
	}
}