//出生证明列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //血统证书号
        me.birthCerRegCode = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //原因显隐
        me.showMessage= ko.observable(false);
        //毛色回显
        me.colorFlag=ko.observable("");
        // me.sendDate=ko.observable();
        //详细数据
        me.detailData = ko.observable({
            birthCerRegCode:"",
            breedCnName:"",
            breedDate:"",
            breeder:"",
            businessState:"",
            colorFlag:"",
            dogColorMarkCn:"",
            createDate:"",
            dogBirthday:"",
            dogBreed:"",
            dogBreedName:"",
            dogEnName:"",
            dogGender:"",
            fdogName:"",
            fdogPedigreeCertified:"",
            fmdogBreedCertifiedCode:"",
            id:"",
            identificationFlag:"",
            isDnaArchive:"",
            isDnaParentsCompare:"",
            mdogName:"",
            mdogPedigreeCertified:"",
            memberCode:"",
            reviewRemarks:"",
            reviewState:"",
            sameBatchNum:"",
            snCode:"",
            sendDate:"",
            activitionEndDate:""
        })
        //颜色list
        me.colorList = ko.observableArray([]);
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findbirthcertificateList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }
            me.findbirthcertificateList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findbirthcertificateList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findbirthcertificateList(false);
            }
            return false;
        }
        //关闭mask
        me.closemask = function(type){
            $("#"+type).css("display","none");
        }
        //修改弹出框点击修改按钮
        me.updateClick = function(){
            $("#updateBtn").attr("class","xg");
            $(".updateshowem").css("display","none");
            $(".updateshowbtn").css("display","inline-block");
            $("#selectDogColor").val(me.colorFlag).trigger("change");

        }
        //选择颜色下拉框方法
        me.changeColor = function(code,en){
            $(".cszse").css("display","none");
            me.detailData().colorFlag = code;
            $("#dogColorMarkCn").html(en);
            me.detailData().dogColorMarkCn = en;
        }
        me.showColor = function(){
            if($(".cszse").css("display")=="block"){
                $(".cszse").css("display","none");
            }else{
                $(".cszse").css("display","block");
            }

        }
        //出生纸详情
        me.getDetail = function(data){
        	if(data.businessState=='已注销'){

        	} else{
        		util.sendAjax({
                    url:'dog/birthcertificate/'+data.id,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        me.detailData(json.data);
                        if(json.data.reviewState=='不通过'||json.data.reviewState=='已注销'){
                        	me.showMessage(true);
                        }else{
                        	me.showMessage(false);
                        }
                        if(json.rc==0){
                            if(Math.floor(new Date("2017-06-01").getTime()/1000)-Math.floor(new Date(json.data.createDate).getTime()/1000)<=0){
                                $("#viewnew").css("display","block");
                            }else{
                                $("#viewold").css("display","block");
                            }
                        }else{
                            layer.msg("信息查询失败:"+data.msg);
                        }
                    }
                });
        	}
        }
        /**
         * 查询方法
         */
        me.findbirthcertificateList = function(isreset){
            if(isreset){
                me.pageNo(1);
            }
            var sendData = {};
            sendData["birthCerRegCode"] = me.birthCerRegCode().trim();
            sendData["snCode"] = "";
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/birthcertificate',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0){
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("登记卡列表为空！")
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //未审核时可以修改
        me.changeMsg = function(data,event){
            if(data.businessState=="待支付"||data.businessState=="待审核"||data.businessState=="未通过"){
                $("#updateBtn").attr("class","old");
                $(".updateshowem").css("display","inline-block");
                $(".updateshowbtn").css("display","none");


                util.sendAjax({
                    url:'dog/birthcertificate/'+data.id,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                    	debugger;
                        me.detailData(json.data);
                        me.colorFlag=json.data.colorFlag;
                        if(json.data.reviewState=='不通过'||json.data.reviewState=='已注销'){
                        	me.showMessage(true);
                        }else{
                        	me.showMessage(false);
                        }
                        if(json.rc==0){
                                $("#updatemask").css("display","block");
                                me.getDogColorList(json.data.dogBreed);
                        }else{
                            layer.msg("信息查询失败:"+data.msg);
                        }
                    }
                });
            }
        }
        me.uploadImg =  function(data,event) {
            var birthCerRegCode = data.birthCerRegCode;
            // location.href = location.href.split("#")[0]+"#/dog/birthcertificateactive";
            if (data.businessState == "激活中" || data.businessState == "超期激活未缴费") {
                location.href = location.href.split("#")[0] + "#/dog/birthcertificateactive?edit=1&birthCerRegCode=" + birthCerRegCode;
            } else if (data.businessState == "激活失败") {
                location.href = location.href.split("#")[0] + "#/dog/birthcertificateactive?error=1&birthCerRegCode=" + birthCerRegCode;
            } else {
                if (data.businessState == '超期未激活') {
                    layer.alert('该犬只的身份识别登记卡发放已超过150天，超过免费激活时间，现激活需要缴纳激活费用200元。', {
                        time: 0 //不自动关闭
                        , btn: ['马上激活', '暂不激活']
                        , yes: function (index) {
                            layer.close(index);
                            location.href = location.href.split("#")[0] + "#/dog/birthcertificateactive?normal=2&birthCerRegCode=" + birthCerRegCode;
                        }
                    });
                } else {
                    location.href = location.href.split("#")[0] + "#/dog/birthcertificateactive?normal=1&birthCerRegCode=" + birthCerRegCode;
                }
            }
        }
        me.uploadImgputaway =  function(data,event){
            var birthCerRegCode = data.birthCerRegCode;
            // location.href = location.href.split("#")[0]+"#/dog/birthcertificateactive";
            if(data.upperStatus=="未上架"){
                location.href = location.href.split("#")[0]+"#/dog/birthcertificateputaway?edit=0&birthCerRegCode=" + birthCerRegCode;
            }else if(data.upperStatus=="待审核"){
                location.href = location.href.split("#")[0]+"#/dog/birthcertificateputaway?edit=2&birthCerRegCode=" + birthCerRegCode;
            }else if(data.upperStatus=="已下架"){
                location.href = location.href.split("#")[0]+"#/dog/birthcertificateputaway?edit=1&putaway=0&birthCerRegCode=" + birthCerRegCode;
            }else{
                location.href = location.href.split("#")[0]+"#/dog/birthcertificateputaway?edit=1&birthCerRegCode=" + birthCerRegCode;
            }
        }
        me.putaway = function(data,event){
            var birthCerRegCode = data.birthCerRegCode;
            var state = data.upperStatus=="已上架" ? '0' : '1';
            var sendData = {"birthCerRegCode":birthCerRegCode,"state":state};
            util.sendAjax({
                url:'dog/dogActivation/upDown',
                async:true,
                loadFlag:true,
                data:JSON.stringify(sendData),
                type:'POST',
                cache:false,
                success:function(json){
                    //debugger;
                    if(json.rc==0){
                        layer.msg("操作成功");
                        me.findbirthcertificateList();
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
        //获取毛色list
        me.getDogColorList = function(dogBreed){
            util.sendAjax({
                url:'dog/dogcolormark/'+dogBreed,
                data:{},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        me.colorList(data.list);
                    }else{
                        layer.msg("毛色获取失败:"+data.msg);
                    }
                }
            });
        }
        //
        me.updateColorName = function(){
            //修改
        	//debugger;
            if(!util.isEnWord(me.detailData().dogEnName)){
                layer.msg("犬名只能为英文！");
                return;
            }
            var updateData = {};
            var dogEnName=me.detailData().dogEnName;
            if($('#updateBtn').hasClass('xg')){//点击过修改按钮
            	var colorFlag=  $("#selectDogColor").select2("val");
            	me.detailData().colorFlag=colorFlag;
            }
            updateData["id"] =  me.detailData().id;
            updateData["dogEnName"] = dogEnName.trim() ;
            updateData["colorFlag"] =  me.detailData().colorFlag;
            util.sendAjax({
                url:'dog/birthcertificate',
                data: JSON.stringify(updateData),
                async:false,
                type:'PUT',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("修改成功!");
                        $("#updatemask").css("display","none");
                    }else{
                        layer.msg("修改失败："+json.msg);
                    }
                }
            });
        }
        ////获取毛色
        //me.getDogFurColor = function(dogBreed,dogGender,dogEnName,birthCerRegCode,id,colorFlag){
        //    util.sendAjax({
        //        url:'dog/dogcolormark/'+dogBreed,
        //        data:{},
        //        async:true,
        //        loadFlag:true,
        //        type:'GET',
        //        cache:false,
        //        success:function(data){
        //            if(data.rc==0){
        //                var changeMsgLayer = layer.open({
        //                    title:'出生证明修改',
        //                    content: "<div class='check-main' style='padding:22px 50px 0'><ul>"
        //                    +"<li><span>出生证明:</span><em>"+birthCerRegCode+"</em></li>"
        //                    +"<li><span>性别：</span><em></em>"+dogGender+"</li>"
        //                    +"<li><span>犬英文名：</span><input type='text' style='width:215px;'value='"+dogEnName+"'id='dogEnName'/></li>"
        //                    +"<li><span>犬只毛色：</span><select name='' id='colorList' style='width:220px;'></select></li>"
        //                    +"</ul></div>",
        //                    area: ['600px', '400px'],
        //                    scrollbar: false,
        //                    btn: ["确定"],
        //                    yes: function(){
        //                            //修改
        //                            var updateData = {};
        //                            updateData["id"] = id;
        //                            updateData["dogEnName"] = $("#dogEnName").val().trim();
        //                            updateData["colorFlag"] = $("#colorList").val();
        //                            util.sendAjax({
        //                                url:'dog/birthcertificate',
        //                                data: JSON.stringify(updateData),
        //                                async:false,
        //                                type:'PUT',
        //                                cache:false,
        //                                success:function(json){
        //                                    if(json.rc==0){
        //                                        layer.msg("修改成功!");
        //                                    }else{
        //                                        layer.msg("修改失败："+json.msg);
        //                                    }
        //                                }
        //                            });
        //                        layer.close(changeMsgLayer);
        //                    }
        //                });
        //                $("#colorList").html("");
        //                $.each(data.list,function(index,item){
        //                    $("#colorList").append("<option value='"+item.dogColorMarkCode+"'>"+item.dogColorMarkCn+"</option>");
        //                    if(item.dogColorMarkCode==colorFlag){
        //                        $("#colorList").children("option").eq(index).attr("selected","selected");
        //                    }
        //                })
        //            }else{
        //                layer.msg("毛色获取失败:"+data.msg);
        //            }
        //        }
        //    });
        //}
        //未通过原因的显隐
        me.showReason = function(data,event){
            if(data.businessState=="不通过"||data.businessState=="未通过") {
                if ($("#reviewCause").css("display") == "none") {
                	$("#reviewCause").css("display", "block");
                } else {
                	$("#reviewCause").css("display", "none");
                }
                $("#reviewRemarks").html(data.reviewRemarks);
            } else if(data.businessState=="已寄出" || data.businessState=="寄出待激活"|| data.businessState=="超期未激活" ){
            	util.sendAjax({
                    url:'expressSend/getByKey',
                    data: {key:data.birthCerRegCode},
                    async:false,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                        	 if ($("#send").css("display") == "none") {
                                 if( data.businessState=="寄出待激活"|| data.businessState=="超期未激活"){
                                     $("#sendMessage").html('快递公司：'+json.data.expressName+'</br>快递单号：'+json.data.expressNo
                                         +'</br>寄出日期：'+data.sendDate.substring(0,10)+'<br/>激活截止日期：'+data.activitionEndDate.substring(0,10));
                                 }else if(data.businessState=="已寄出"){
                                     $("#sendMessage").html('快递公司：'+json.data.expressName+'</br>快递单号：'+json.data.expressNo);
                                 }
                             	$("#send").css("display", "block");
                             } else {
                             	$("#send").css("display", "none");
                             }
                        }else{
                            layer.msg("获取信息失败："+json.msg);
                        }
                    }
                });
            }
        }
        me.boxAlert = function(data,event){
            layer.alert('该犬只的身份识别登记卡发放已超过150天，需要您前往地方俱乐部办理激活')
        }
        me.closeReason = function(data,event){
            $(event.target).parents(".reason").css("display","none")
        }
        me.isbd = ko.observable(true);//默认不显示
        //区分专业会员和普通会员
        me.addBirthcertificate = function () {
            if (userInfo.getMember().memberType== "basic") {
                me.isbd(false);
            } else {
                window.location.href = "#/dog/dognewbornlist";
            }
        }
        //去缴费
        me.toOrderCheck = function(data,event){
            util.sendAjax({
                url: "dog/dogActivation/isHaveOrder/",
                data: {birthCode:data.birthCerRegCode},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                   if(json.rc == '0'){
                       var orderId = json.data.orderId;
                       if(orderId != ""){
                           location.href = location.href.split("#")[0] + "#/payment/payment?id="+orderId;
                       }else{
                           location.href = location.href.split("#")[0] + "#/order/check";
                       }
                   } else {
                       layer.msg("会员升级失败,错误代码:" + json.rc + "错误信息:" + json.msg);
                   }
                }
            });
        }
        //点击升级会员/暂不升级退出事件
        me.changeTopNav = function(type) {
            if (type == "no") {//退出
                me.isbd(true);
            } else if (type == 'bd') {//升级
            	util.sendAjax({
                    url: 'member/upgrade',
                    data: {},
                    async: false,
                    type: 'POST',
                    cache: false,
                    success: function (json) {
                        if (json.rc == 0) {
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                , btn: ['跳转', '取消']
                                , yes: function (index) {
                                    layer.close(index);
                                    location.href = location.href.split("#")[0] + "#/order/check";
                                }
                            });
                        } else {
                            layer.msg("会员升级失败,错误代码:" + json.rc + "错误信息:" + json.msg);
                        }
                    }
                });
            }
        }
        //初始化
        $(function(){
            me.findbirthcertificateList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});