//业务订单核对
var localCartId = [];
var localReceiverProvince = "";
var localReceiverCity = "";
var localReceiverAddress = "";
var localPostcode = "";
var localDel = "";
var localReceiver = "";
/**
 * 查询购物车
 */
function findCartList(){
    util.sendAjax({
        url:'finance/cart',
        data:{},
        async:false,
        type:'GET',
        cache:false,
        success:function(json){
            if(json.rc==0){
                var list = json.items;
                if(list!=null && list.length>0){
                    var html = "";
                    var cartNum = 0;
                    var cartPrice = 0;
                    $.each(list,function(index,item){
                        html+="<tr><td>"+item.chargingItemId+"</td>"+
                            "<td>"+item.chargingItemName+"</td>"+
                            "<td>￥ "+item.totalPrice+"</td><td>"+item.num+"</td><td><a onclick=\"delCart('"+item.id+"')\">删除</a></td></tr>";
                        cartNum+=parseInt(item.num);
                        cartPrice+=parseFloat(item.totalPrice);
                        localCartId.push(item.id);
                    });
                    $("#showContent").html(html);
                    $("#cartNum").html(cartNum);
                    $("#cartPrice").html(cartPrice.toFixed(2));
                }
            }
        }
    });
}
//得到个人信息
function getUserInfo(){
    var member = userInfo.getMember();
    localReceiverProvince = member.province;
    localReceiverCity = member.city;
    localReceiverAddress = member.street;
    localPostcode = member.postcode;
    localDel = member.mobile;
    localReceiver = member.name;
    $("#receiver").html(localReceiver);
    $("#localDel").html(localDel);
    $("#receiverProvince").html(localReceiverProvince+""+localReceiverCity+""+localReceiverAddress);
    $("#postcode").html(localPostcode);
}
/**
 * 保存订单
 */
function saveOrder(){
    if(localCartId.length==0){
        layer.open({
            content: "没有业务信息，请添加业务信息！"
            ,btn: '确定'
        });
        return;
    }
    if(util.isVal(localReceiverProvince)==""){
        layer.open({
            content: "收件人所在省不能为空"
            ,btn: '确定'
        });
        return;
    };
    if(util.isVal(localReceiverCity)==""){
        layer.open({
            content: "收件人所在市不能为空"
            ,btn: '确定'
        });
        return;
    }
    if(util.isVal(localReceiverAddress)==""){
        layer.open({
            content: "收件人所在街道不能为空"
            ,btn: '确定'
        });
        return;
    }
    //if(util.isVal(localPostcode)==""){
    //    layer.open({
    //        content: "收件人邮编不能为空！"
    //        ,btn: '确定'
    //    });
    //    return;
    //}
    if(util.isVal(localDel)==""){
        layer.open({
            content: "收件人电话不能为空！"
            ,btn: '确定'
        });
        return;
    }
    if(util.isVal(localReceiver)==""){
        layer.open({
            content: "收件人姓名不能为空！"
            ,btn: '确定'
        });
        return;
    }
    var sendData = {};
    sendData["carts"] = localCartId;
    sendData["receiverProvince"] = localReceiverProvince;
    sendData["receiverCity"] = localReceiverCity;
    sendData["receiverAddress"] = localReceiverAddress;
    sendData["postcode"] = localPostcode;
    sendData["del"] = localDel;
    sendData["receiver"] = localReceiver;
    util.sendAjax({
        url:'finance/order',
        data:JSON.stringify(sendData),
        async:true,
        loadFlag:true,
        type:'POST',
        cache:false,
        success:function(json){
            if(json.rc ==0){
                layer.open({
                    content: "添加业务订单成功！"
                    ,btn: '确定'
                    ,yes: function(index){
                        window.location.href="mobilePayment.html?id="+json.data.id;
                    }
                });

            }else{
                layer.open({
                    content: "添加业务订单失败,错误代码:"+json.rc+"错误信息:"+json.msg
                    ,skin: 'msg'
                    ,time: 2 //2秒后自动关闭
                });
            }
        }
    });
}
/**
 * 删除购物车
 */
function delCart(id){
    layer.open({
        content: '您确认删除此项业务？'
        ,btn: ['确定', '取消']
        ,yes: function(){
            util.sendAjax({
                url:'finance/cart/'+id,
                data:{},
                async:true,
                loadFlag:true,
                type:'DELETE',
                cache:false,
                success:function(json){
                    if(json.rc ==0){
                        window.location.reload();
                    }else{
                        layer.open({
                            content: "删除购物车商品失败,错误代码:"+json.rc+"错误信息:"+json.msg
                            ,skin: 'msg'
                            ,time: 2 //2秒后自动关闭
                        });
                    }
                }
            });
        }
    });
}
$(function(){
    getUserInfo();
    findCartList();
});