//业务订单列表
/**
 * 查询业务订单列表
 */
function findOrderList(page){
    var paymentState = $("#paymentState").val();
    var sendData = {};
    sendData["paymentState"] = paymentState;
    sendData["pageSize"] ="10";
    sendData["pageNo"] = page;
    util.sendAjax({
        url:'finance/order',
        data:sendData,
        async:true,
        type:'GET',
        cache:false,
        success:function(json){
            console.log(json);
            if(json.rc==0){
                if(json.list!=null && json.list.length>0){
                    var html = "";
                    $.each(json.list,function(index,item){
                        html+="<li><span class=\"nodetxt block\">订单编号："+item.orderCode+"</span>"+
                            "<span class=\"nodetxt block\">订单总额：<i class=\"num\">"+item.totalPrice+"</i> 元</span>"+
                            "<span class=\"nodetxt block\">提交时间："+item.addTime+"</span>"+
                            "<span class=\"nodetxt block\">支付方式："+item.paymentWay+"</span>"+
                            "<span class=\"nodetxt block pdt2 mb5\"><i class=\"oder_pay_finish\"><font color=green>"+item.paymentStateName+"</font></i>";
                        if(item.paymentWay !="现场微信支付" && item.paymentState=="1"){
                            html+="<a href='javascript:;'  onclick='toPaymentPage(\""+item.id+"\")' style='color: red; margin-left: 10px;'>缴费</a><a href='javascript:;' onclick='delOrder(\""+item.id+"\")' style='color: red;margin-left: 10px;'>删除</a>";
                        }
                            html+="</span><div class=\"datawarp nodetxt pdt2\">"+
                            "<table width=\"100%\" class=\"datalist\"><thead><tr><th width=\"18%\">业务编号</th><th width=\"72%\">业务名称</th><th width=\"10%\">数量</th></tr></thead>"+
                            "<tbody>";
                        if(item.items!=null && item.items.length>0){
                            var detail = item.items;
                            for(var i=0;i<detail.length;i++){
                                html+="<tr><td>"+detail[i].chargingItemId+"</td><td><span class=\"popupbtn\">"+detail[i].chargingItemName+"</span></td><td>"+detail[i].num+"</td></tr>";

                            }
                        }
                        html+="</tbody></table></div></li>";
                    })
                    $("#showContent").html(html);
                    initPage(page,10,json.total);
                }else{
                    $("#showContent").html("");
                    initPage(page,10,1);
                }
            }else{
                layer.open({
                    content: "查询我的业务订单失败,错误代码:"+json.rc+"错误信息:"+json.msg
                    ,skin: 'msg'
                    ,time: 2 //2秒后自动关闭
                });
            }

        }
    });
}
function toPaymentPage(id){
    window.location.href="mobilePayment.html?id="+id;
}
/**
 * 删除订单
 */
function delOrder(id){
    //询问框
    layer.open({
        content: "确认删除此订单么！"
        ,btn: ['确定','关闭'] //按钮
        ,yes:function(index){
            util.sendAjax({
                url:'finance/order/'+id,
                data:{},
                async:true,
                loadFlag:true,
                type:'DELETE',
                cache:false,
                success:function(json){
                    layer.close(index);
                    if(json.rc==0){
                        findOrderList(1);
                    }else{
                        layer.open({
                            content: "删除订单失败,错误代码:"+json.rc+"错误信息:"+json.msg
                            ,skin: 'msg'
                            ,time: 2 //2秒后自动关闭
                        });
                    }
                }
            });
        }
    });
}
//初始化分页
function initPage(nowPage,pageSize,total){
    var html="<div class=\"new-tbl-cell\"><a href=\"?page="+(nowPage==1?1:nowPage-1)+"\" class=\"new-a-prve\"><span>上一页</span></a></div>"+
        "<div class=\"new-tbl-cell new-p-re\"><div class=\"new-a-page\"><span class=\"new-open\">"+nowPage+"/"+Math.ceil(total/pageSize)+"</span></div>"+
        "<select class=\"new-select\" onchange=\"window.location.href=this.value;\">";
    for(var i=1;i<=Math.ceil(total/pageSize);i++){
        html+="<option value=\"?page="+i+"\" "+(nowPage==i?'selected':'')+">第"+i+"页</option>";
    }
    html+="</select></div><div class=\"new-tbl-cell\"><a class=\"new-a-next\" href=\"?page="+(nowPage==Math.ceil(total/pageSize)?nowPage:parseInt(nowPage)+1)+"\"><span>下一页</span></a></div>";
    $("#showPageContent").html(html);
}
$(function(){
    var page =1;
    var obj = util.getQueryString();
    if(obj.page==undefined){
        page=1;
    }else{
        page=obj.page;
    }
    findOrderList(page);
});