//会员信息完善页面
define(["knockout"], function(ko) {
  return function(context) {
    var me = this;
    var checkAgreement = false;
    me.provinceHtml = ko.observable(util.city[0].local);
    me.cityHtml = ko.observable(util.city[0].localcity[0]);
    me.name = ko.observable("");
    me.code = ko.observable("");
    me.province = ko.observable("");
    me.city = ko.observable("");
    me.address = ko.observable("");
    me.sendType = ko.observable("到付快递");
    //省List
    me.provinceList = ko.observableArray([]);
    //市List
    me.cityList = ko.observableArray([]);
    me.chooseBasic = function() {
      $("#basic").removeClass();
      $("#basic").addClass("menberbox fl active");
      $("#professional").removeClass();
      $("#professional").addClass("menberbox fr");
      $("#memberType").val("basic");
    };
    me.chooseProfessional = function() {
      $("#professional").removeClass();
      $("#professional").addClass("menberbox fr active");
      $("#basic").removeClass();
      $("#basic").addClass("menberbox fl");
      $("#memberType").val("professional");
    };
    me.showSendType = function() {
      if ($("#sendType").css("display") == "none") {
        $("#sendType").css("display", "block");
      } else {
        $("#sendType").css("display", "none");
      }
    };
    me.showProvince = function() {
      if ($("#provinceDiv").css("display") == "none") {
        $("#provinceDiv").css("display", "block");
      } else {
        $("#provinceDiv").css("display", "none");
      }
      $("#cityDiv").css("display", "none");
    };
    me.showCity = function() {
      for (var i = 0; i < util.city.length; i++) {
        if (me.provinceHtml() == util.city[i].local) {
          me.initProCity(me.provinceHtml(), util.city[i].localcity[0]);
        }
      }
      if ($("#cityDiv").css("display") == "none") {
        $("#cityDiv").css("display", "block");
      } else {
        $("#cityDiv").css("display", "none");
      }
      $("#provinceDiv").css("display", "none");
    };
    me.changeProvince = function(data) {
      me.provinceHtml(data);
      for (var i = 0; i < util.city.length; i++) {
        if (data == util.city[i].local) {
          me.initProCity(data, util.city[i].localcity[0]);
        }
      }
      $("#provinceDiv").css("display", "none");
    };
    me.changeCity = function(data) {
      me.cityHtml(data);
      $("#cityDiv").css("display", "none");
    };
    me.initProCity = function(province, city) {
      me.provinceList().length = 0;
      me.cityList().length = 0;
      me.provinceHtml(province);
      me.cityHtml(city);
      for (var i = 0; i < util.city.length; i++) {
        me.provinceList.push(util.city[i].local);
        if (province == util.city[i].local) {
          for (var j = 0; j < util.city[i].localcity.length; j++) {
            me.cityList.push(util.city[i].localcity[j]);
          }
        }
      }
    };
    me.check = function() {
      if ($("#checkAgreement").attr("class") == "radio checked") {
        $("#checkAgreement").removeClass();
        $("#checkAgreement").addClass("radio");
        checkAgreement = true;
      } else if ($("#checkAgreement").attr("class") == "radio") {
        $("#checkAgreement").removeClass();
        $("#checkAgreement").addClass("radio checked");
        checkAgreement = false;
      }
    };
    me.submit = function() {
      if (util.isVal(me.name()) == "") {
        layer.msg("请填写姓名");
        return;
      }
      if (util.isVal(me.code()) == "") {
        layer.msg("请填写身份证号");
        return;
      } else if (!util.isCardNo(me.code())) {
        layer.msg("身份证号格式不正确");
        return;
      }
      if (util.isVal(me.address()) == "") {
        layer.msg("请填写详细地址");
        return;
      }
      if (checkAgreement) {
        var sendData = {};
        sendData["realName"] = me.name();
        sendData["idCard"] = me.code();
        util.sendAjax({
          url: "open/getSessionMobile",
          data: JSON.stringify(sendData),
          async: true,
          loadFlag: true,
          type: "POST",
          cache: false,
          success: function(json) {
            if (json.rc == 0) {
              $("#confimPhone").html(json.data.mobile);
              if ($("#memberType").val() == "basic") {
                $("#cofimType").html("基础会员");
              } else if ($("#memberType").val() == "professional") {
                $("#cofimType").html("专业会员");
              }
              $("#confimName").html(me.name());
              $("#confimCode").html(me.code());
              $("#confimPost").html(me.sendType());
              $("#confimAddress").html(
                me.provinceHtml() + me.cityHtml() + me.address()
              );
              $("#confimMessage").show();
            } else {
              layer.msg("错误编码:" + json.rc + "错误信息:" + json.msg);
            }
          }
        });
      } else {
        layer.msg("请阅读并同意《CKU注册协议》");
      }
    };
    me.returnData = function() {
      $("#confimMessage").hide();
    };
    me.changeSendType = function(data) {
      me.sendType(data);
      $("#sendType").css("display", "none");
    };
    me.submitAll = function() {
      var sendData = {};
      sendData["mobile"] = $("#confimPhone").html();
      sendData["newPassword"] = "123456";
      sendData["name"] = $("#confimPhone").html();
      sendData["loginName"] = $("#confimPhone").html();
      //会员类型
      sendData["memberType"] = $("#memberType").val();
      //姓名
      sendData["realName"] = me.name();
      //身份证号
      sendData["cardNo"] = me.code();
      //手机号
      sendData["phone"] = $("#confimPhone").html();
      //邮寄方式
      sendData["deliveryCertified"] = me.sendType();
      sendData["province"] = me.provinceHtml();
      sendData["city"] = me.cityHtml();
      sendData["street"] = me.address();
      util.sendAjax({
        url: "open/newRegister",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            layer.msg("注册成功！");
            window.location.href = "#/login/success";
          } else {
            layer.msg("注册失败,错误代码:" + json.rc + "错误信息:" + json.msg);
          }
        }
      });
    };
    $(function() {
      for (var i = 0; i < util.city.length; i++) {
        me.provinceList.push(util.city[i].local);
        for (var j = 0; j < util.city[i].localcity.length; j++) {
          me.cityList.push(util.city[i].localcity[j]);
        }
      }
    });
    context.app.loading(false);
  };
});