//赛事鉴定申请
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //犬种搜索值
        me.dogBreed = ko.observable("");
        me.dogBreedSearch = ko.observable("");
        me.dogBreedRealList = ko.observableArray([]);
        //犬种list
        me.dogBreedList = ko.observableArray([]);
        me.dogBreedHtml = ko.observable("请选择犬种");
        //毛色
        me.dogColorMarkCode = ko.observable("");
        me.dogColorMark = ko.observable("");
        me.dogColorMarkList = ko.observableArray([]);
        //犬名
        me.dogName = ko.observable("");
        me.dogGender = ko.observable("1");
        me.mainShowId = ko.observable("");
        me.birthday = ko.observable("");
        //犬种列表初始化
        me.initDogBreedList = function(){
            util.sendAjax({
                url:'dog/dogtype/fci',
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length<=0){
                        }else if(data.list.length>0){
                            var withlist = [];
                            for(var i=0;i<data.list.length;i++){
                                if(data.list[i].breedCnName.indexOf("藏獒")<0){
                                    withlist.push(data.list[i]);
                                }
                            }
                            withlist.unshift({'breedCnName':"请选择犬种","dogBreedCode":'' });
                            me.dogBreedList(withlist);
                            me.dogBreedRealList(withlist.slice(0));
                        }
                    }else{
                        layer.msg("犬种列表查询失败:"+data.msg);
                    }
                }
            });
        }
        //犬种的显隐
        me.showDogBreedHtml  = function(){
            if($("#dogBreedDiv").css("display")=="none"){
                $("#dogBreedDiv").css("display","block");
            }else{
                $("#dogBreedDiv").css("display","none");
            }
        }

        //犬种搜索change事件
        me.dogBreedChange = function(data){
            if(util.isVal(me.dogBreedSearch())==""){
                me.dogBreedRealList(me.dogBreedList().slice(0));
            }
            me.dogBreedRealList.removeAll();
            for(var i=0;i<me.dogBreedList().length;i++){
                if(me.dogBreedList()[i].breedCnName.indexOf(me.dogBreedSearch())>-1){
                    me.dogBreedRealList.push(me.dogBreedList()[i]);
                }
            }
        }
        //选中犬种事件
        me.changeDogBreed = function(data,event){
			var dogBreed= $("#selectDogBreed").select2("val");
			var dogBreeds=dogBreed.split("dogType-")[1];
            me.dogBreed(dogBreeds);
            if(dogBreeds!=''){
            	util.sendAjax({
            		url:'dog/dogcolormark/'+dogBreeds,
            		async:true,
            		loadFlag:true,
            		type:'GET',
            		cache:false,
            		success:function(data){
            			if(data.rc==0){
            				data.list.unshift({'dogColorMarkCn':"请选择毛色","dogColorMarkCode":'' });
            				me.dogColorMarkList(data.list);
            			}else{
            				layer.msg("犬只毛色查询失败:"+data.msg);
            			}
            		}
            	});
            }
        }

        //犬种的毛色
        me.showDogColorHtml  = function(){
            if($("#dogColorMarkDiv").css("display")=="none"){
                $("#dogColorMarkDiv").css("display","block");
            }else{
                $("#dogColorMarkDiv").css("display","none");
            }
        }
        //选中犬种的毛色
        me.changeDogColor = function(data,event){
            me.dogColorMark(data.dogColorMarkCn);
            $("#dogColorMarkDiv").css("display","none");
            me.dogColorMarkCode(data.dogColorMarkCode);
        }
        //公母
        me.changeDogGender = function(type){
            $("#dogGender1").removeAttr("class");
            $("#dogGender2").removeAttr("class");
            $("#dogGender"+type).attr("class","radio");
            me.dogGender(type);
        }
        //提交鉴定报名
        me.save = function(){
                var sendData = {};
                var dogBreed = me.dogBreed();
             	var dogColor= $("#selectColorFlag").select2("val");
                if (util.isVal(dogBreed) == "") {
                    layer.msg("犬种不能为空！");
                    return;
                }
                if (util.isVal(dogColor) == "") {
                    layer.msg("犬只毛色不能为空！");
                    return;
                }
                var dogName = me.dogName();
                if (util.isVal(dogName) == "") {
                    layer.msg("犬名不能为空！");
                    return;
                }
                var birthday = $("#birthday").val();
                if (util.isVal(birthday) == "") {
                    layer.msg("出生日期不能为空！");
                    return;
                }
                var dogGender = me.dogGender();
                if (util.isVal(dogGender) == "") {
                    layer.msg("犬只性别不能为空！");
                    return;
                }
                sendData["mainShowId"] = me.mainShowId();
                sendData["dogBreed"] = dogBreed;
                sendData["dogName"] = dogName;
                sendData["dogGender"] = dogGender;
                sendData["dogFurColor"] = dogColor;
                sendData["birthday"] = birthday;
                sendData["stickerFlag"] = me.applyChecked() ? 1:0;
                util.sendAjax({
                    url: 'dog/dogappraisal',
                    data: JSON.stringify(sendData),
                    async: true,
                    loadFlag: true,
                    type: 'POST',
                    cache: false,
                    success: function (json) {
                        if (json.rc == 0) {
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                , btn: ['跳转', '取消']
                                , yes: function (index) {
                                    layer.close(index);
                                    location.href = location.href.split("#")[0] + "#/order/check";
                                }
                            });
                        } else {
                            layer.msg("犬只鉴定报名失败:" + json.msg);
                        }
                    }
                });
        }
        /*宠爱护照及等级贴纸申请*/
        me.applyChecked = ko.observable(false);
        /*宠爱护照及等级贴纸申请*/
        me.toggleSelect = function(){
            me.applyChecked(!me.applyChecked());
        }
        $(function(){
            var obj = util.getQueryString();
            me.initDogBreedList();
            me.mainShowId(obj.id);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});