<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
						loading('正在提交，请稍等...');
						form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var option = "";
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${member.province}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#province").append(html);
						if(option!=''){
							$("#province").val(option).select2().change();
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});
			
			//根据会员类别来改变需要输入的信息
			var type = '${member.memberType}';
			if (type=='basic') {
				$("#kennel").hide();
				$(".kennel").val("");
			}else if(type=='professional'){
				$("#kennel").show();
			}
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:会员编辑</a></li>
	</ul>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	<div style = "clear:both;"></div>
	<form:form id="inputForm" modelAttribute="member" action="${ctxSchools}/schoolsMember/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:select path="gender" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text"  readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd"/>"/>
					<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件类型：</label>
			<div class="controls">
				<form:select path="cardType" class="input-small required" disabled="true">
					<form:option value="身份证">身份证</form:option>
					<form:option value="护照">护照</form:option>
				</form:select>
			</div>
		</div> 
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<form:input path="cardNo" htmlEscape="false"  readonly="true" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" onBlur="checkMobile()" maxlength="11" class="input-xlarge required isMobile"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkMobile() {
					mobile = $("#mobile").val();
					id=$("#id").val();
					if (mobile != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/mobileCheck?param="+mobile+"&id="+id,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("手机号已经存在!");
									$("#mobile").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="60" class="input-xlarge isZipCode" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<form:input path="qq" htmlEscape="false" maxlength="50" class="input-xlarge isQq"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="200" class="input-xlarge isPhone"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<form:input path="fax" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<form:input path="email" htmlEscape="false" onBlur="checkEmail()" maxlength="200" class="input-xlarge email required"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkEmail() {
					email = $("#email").val();
					id=$("#id").val();
					if (email != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/emailCheck?param="+email+"&id="+id,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("邮箱已经存在!");
									$("#email").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var option = "";
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
								if('${member.city}'==lists[i].city) {
									option = lists[i].city;
								}
							}
							$("#city").append(html);
							if(option!=''){
								$("#city").val(option).select2().change();
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="area" path="area" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#city").change(function(){
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var option = "";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
								if('${member.area}'==lists[i].area) {
									option = lists[i].area;
								}
							}
							$("#area").append(html);
							if(option!=''){
								$("#area").val(option).select2().change();
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
			<div class="control-group" style="width:50%">
			<label class="control-label">证件照：</label> 
			<div class="controls">
			 	<div class="file-portrait">
			 		<c:if test="${not empty member.avatar }">
	              		 <img id="avatarPreview" style="max-width:117px;max-height:150px;background-color: antiquewhite;border: 1px solid;"  onclick="uploadImg()" src="${ctxSchools}/file/image/${fns:escapeHtml(member.avatar)}">
			 			   &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <font style="color:red;">参考样张--></font> &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;
              		 	<img id="review" style="max-width:117px;max-height:150px;"  src="${ctxStatic}/images/avatar_prospectus.jpg">
			 		</c:if>
			 		<c:if test="${empty member.avatar }">
			 			 <img id="avatarPreview" style="max-width:117px;max-height:150px;background-color: antiquewhite;border: 1px solid;"  onclick="uploadImg()" src="${ctxStatic}/images/head.png">
			 			  &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <font style="color:red;">参考样张--></font> &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;
              		 	<img id="review" style="max-width:117px;max-height:150px;"  src="${ctxStatic}/images/avatar_prospectus.jpg">
			 		</c:if>
               </div>
                <p><a id="uploadImg" href="javascript:;" onclick="uploadImg()">点击上传证件照</a></p>
				<form:input path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
			        function uploadImg(){
			        	layer.open({
			        		  type: 2,
			        		  title: '证件照上传',
			        		  shadeClose: true,
			        		  shade: 0.8,
			        		  area: ['480px', '340px'],
			        		  content:'${ctxSchools}/file/uploadPage'
			        		}); 
			        }
				</script>
				<span style="color:red;">证件照要求：请提交证书照片(正规白底免冠证件照) </br> 格式要求：白底、JPEG格式、3×4.2厘米、分辨率300dpi</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员类别：</label>
			<div class="controls">
				<form:select path="memberType" class="input-small required" disabled="true">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_member_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<form:select path="groomerType" class="input-small required" disabled="true">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_groomer_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属学校：</label>
			<div class="controls">
				<form:input path="ckuClub"  htmlEscape="false" maxlength="100" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员开始日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly"  maxlength="20" class="input-medium "
					value="<fmt:formatDate value="${member.createDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员结束日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium"
				value="<fmt:formatDate value="${member.groomerEndDate}" pattern="yyyy-MM-dd"/>"
				/>
			</div>
		</div>
	
		<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
		
		<div class="control-group">
			<label class="control-label">邮寄 -证书类：</label>
			<div class="controls">
				<form:select path="deliveryCertified" class="input-small required " >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_certified')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮寄-通知类：</label>
			<div class="controls">
				<form:select path="deliveryNotice" class="input-small required" >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_notice')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="remarks" htmlEscape="false"  maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记人：</label>
			<div class="controls">
				 <form:input path="registrant" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true" />
			 </div>
		 </div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>