<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
						}
						$("#province").append(html);
					}else{
						layer.msg(json.msg);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/user/member/">会员列表</a></li>
		<shiro:hasPermission name="sys:user:member:add"><li><a href="${ctx}/sys/user/member/form">添加会员</a></li></shiro:hasPermission>
		<li class="active"><a href="${ctx}/sys/user/member/tcform?id=${member.id}">淘宠会员<shiro:hasPermission name="sys:user:member:edit">${not empty member.id?'修改':'注册'}</shiro:hasPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="member" action="${ctx}/sys/user/member/tcsave" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="memberSite" value=""/>
		<sys:message content="${message}"/>
		<h3>淘宠会员基本信息</h3>
		<div class="control-group" style="width:80%">
			<label class="control-label">证件照正面：</label> 
			<div class="controls">
				<sys:singleImgUpload module="member" imgId="avatar" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:select path="gender" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<form:input path="cardNo" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="60" class="input-xlarge isZipCode" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<form:input path="qq" htmlEscape="false" maxlength="50" class="input-xlarge isQq"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="200" class="input-xlarge isPhone"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<form:input path="fax" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<form:input path="email" htmlEscape="false" maxlength="200" value="" class="input-xlarge email"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
							}
							$("#city").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="area" path="area" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#city").change(function(){
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
							}
							$("#area").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员类别：</label>
			<div class="controls">
				基础会员
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">淘宠合同编号：</label>
			<div class="controls">
				<form:input path="contractCode" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div style = "clear:both;"></div>
		<div class="form-actions">
			<shiro:hasPermission name="sys:user:member:tcadd"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>