<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>计划任务管理管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function start(){
			window.location.href="${ctx}/systask/sysTask/startAll";
		}
		function shutdownAll(){
            window.location.href="${ctx}/systask/sysTask/shutdownAll";
        }
		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/systask/sysTask/">计划任务管理列表</a></li>
		<shiro:hasPermission name="systask:sysTask:edit"><li><a href="${ctx}/systask/sysTask/form">计划任务管理添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="taskTrigger" action="${ctx}/systask/sysTask/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>工作计划名称：</label>
				<form:input path="jobName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>任务组名：</label>
				<form:input path="jobGroup" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>最后执行时间：</label>
				<input name="lastExecuteTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${sysTask.lastExecuteTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
			</li>
			<li><label>当前状态：</label>
				<form:select path="state" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('taskState')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><input id="startAll" class="btn btn-primary" type="button" onclick="start()" value="全部开启"/></li>
			<li class="btns"><input id="stopAll" class="btn btn-primary" type="button" onclick="shutdownAll()" value="全部暂停"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>工作计划描述</th>
				<th>工作计划名称</th>
				<th>任务组名</th>
				<th>任务执行类名</th>
				<th>触发时间格式</th>
				<th>最后执行时间</th>
				<th>当前状态</th>
				<th>备注信息</th>
				<shiro:hasPermission name="systask:sysTask:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sysTask">
			<tr>
				<td>
					${sysTask.jobInfo}
				</td>
				<td>
					${sysTask.jobName}
				</td>
				<td>
					${sysTask.jobGroup}
				</td>
				<td>
					${sysTask.jobCls}
				</td>
				<td>
					${sysTask.timeFormat}
				</td>
				<td>
					<fmt:formatDate value="${sysTask.lastExecuteTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
				    <a href="${ctx}/systask/sysTask/changeState?id=${sysTask.id}" onclick="return confirmx('确认开启/关闭该任务吗？', this.href)">
				    <c:if test="${sysTask.state==0}"><font color="red"></c:if>
					   ${fns:getDictLabel(sysTask.state, 'taskState', '')}
					<c:if test="${sysTask.state==0}"></font></c:if>
					</a>
				</td>
				<td>
					${sysTask.remarks}
				</td>
				<shiro:hasPermission name="systask:sysTask:edit"><td>
				    <a href="${ctx}/systask/sysTask/executeOnce?id=${sysTask.id}" onclick="return confirmx('确认立即执行一次该任务吗？',this.href)">立即执行一次</a>
    				<c:if test="${sysTask.state==1}">
                    <a href="${ctx}/systask/sysTask/form?id=${sysTask.id}" onclick="return confirmx('请先暂停计划任务再操作','javascript:void(0)' )">修改</a>
                    <a href="${ctx}/systask/sysTask/delete?id=${sysTask.id}" onclick="return confirmx('请先暂停计划任务再操作', 'javascript:void(0)')">删除</a>
                    </c:if>
                    <c:if test="${sysTask.state==0}">
                    <a href="${ctx}/systask/sysTask/form?id=${sysTask.id}">修改</a>
                    <a href="${ctx}/systask/sysTask/delete?id=${sysTask.id}" onclick="return confirmx('确认要删除该计划任务管理吗？', this.href)">删除</a>
                    </c:if>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>