<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>单犬种俱乐部管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/singleOrg/">单犬种俱乐部列表</a></li>
		<shiro:hasPermission name="sys:singleOrg:edit"><li><a href="${ctx}/sys/singleOrg/addForm">单犬种俱乐部添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="org" action="${ctx}/sys/singleOrg/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>机构名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>状态：</label>
				<form:select path="state" class="input-small">
					<form:option value="all">全部</form:option>
					<form:option value="0">开放</form:option>
					<form:option value="1">关闭</form:option>
				</form:select>
			</li>
            <li><label>审核状态：</label>
                <form:select path="shenHeState" class="input-small">
					<form:option value="">全部</form:option>
                    <form:option value="0">待审核</form:option>
                    <form:option value="1">通过</form:option>
                    <form:option value="2">未通过</form:option>
                </form:select>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>机构名称</th>
				<th>合作编号</th>
				<th>状态</th>
				<th>截止日期</th>
				<th>审核</th>
				<th>押金</th>
				<th>余额</th>
				<th>优惠券数量</th>
				<th>官网是否显示</th>
				<th>邮寄管理</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="org">
			<tr>
				<td><a href="${ctx}/sys/singleOrg/editForm?id=${org.id}">
					${org.name}
				</a></td>
				<td>
						${org.memberCode }
				</td>

				<td>
					<c:if test="${org.endDate gt currentDate}" > <font color="green">开放</font></c:if>
					<c:if test="${org.endDate lt currentDate}" > <font color="red">关闭</font> </c:if>
					<c:if test="${org.endDate eq currentDate}" > 今天关闭 </c:if>
				</td>
				<td>
					<fmt:formatDate value="${org.endDate}" type="date" pattern="yyyy-MM-dd "/>

				</td>
				<td>
					<c:if test="${org.shenHeState==0}" > 未审核 </c:if>
					<c:if test="${org.shenHeState==1}" > 通过 </c:if>
					<c:if test="${org.shenHeState==2}" > 未通过 </c:if>
				</td>
				<td>
					${org.deposit}
				</td>
				<td>
						${org.member.accountBalance}
				</td>
				<td>
						${org.memberCouponNum-org.memberCouponNumCanUse}/${org.memberCouponNum}
				</td>
				<td>
						${fns:getDictLabel(org.displayOnWeb, 'yes_no', '')}
				</td>
				<td>
					<a href="${ctx}/sys/orgChip/add?orgId=${org.id}">物资录入</a>
					<a href="${ctx}/sys/orgChip/group?orgId=${org.id}">物资管理</a>
				</td>

				<td>
					<shiro:hasPermission name="sys:singleOrg:edit">
    					<a href="${ctx}/sys/singleOrg/editForm?id=${org.id}">修改</a>
    				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>