<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>认证师管理</title>
	<meta name="decorator" content="default"/>
	<style>
		/* .form-horizontal .control-label{
			width:120px !important;
		} */
		.form-horizontal .control-label{
			padding:2px;
		}
		.form-horizontal .controls{
			padding:2px;
		}
		.form-horizontal .control-group-head input{
			width:255px;
		}
		.control-group-head{
			width: 50%;
			float: left;
		}
		/* .picDiv>div{
			width:33%;
		} */
	</style>
	<%-- <link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/> --%>
	<link href="${ctxStatic}/layui_2/layui/css/layui.css" type="text/css" rel="stylesheet"/>
	<script src="${ctxStatic}/layui_2/layui/layui.all.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					if($("#photo").val()==null||$("#photo").val()==""){
						alert("请上传认证师照片");
						$("#photoErr").show();
						return;
					}else{
						$("#photoErr").hide();
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/appraiser/">认证师列表</a></li>
		<li class="active"><a href="${ctx}/sys/appraiser/form?id=${appraiser.id}">认证师<shiro:hasPermission name="sys:appraiser:edit">${not empty appraiser.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="sys:appraiser:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="appraiser" action="${ctx}/sys/appraiser/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<div class="control-group-head">
			<c:if test="${!empty appraiser.certificateNum}">	
				<div class="control-group">
					<label class="control-label">证书编号：</label>
					<div class="controls">
						${appraiser.certificateNum}
					</div>
				</div>
			</c:if>
			<div class="control-group">
				<label class="control-label">认证师姓名：</label>
				<div class="controls">
					<form:input path="name" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">认证师姓名拼音：</label>
				<div class="controls">
					<form:input path="nameEn" htmlEscape="false" maxlength="64" class="input-xlarge required isEnName"/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<%-- <div class="control-group">
				<label class="control-label">认证师照片：</label>
				<div class="controls">
					<form:input path="photo" htmlEscape="false" maxlength="256" class="input-xlarge required"/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div> --%>
			<div class="control-group">
				<label class="control-label">联系电话：</label>
				<div class="controls">
					<form:input path="mobile" htmlEscape="false" maxlength="20" class="input-xlarge required isTel"/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">省份：</label>
				<div class="controls">
					<form:select id="province" path="province" class="input-xlarge required">
						<form:option value=""></form:option>
						<c:forEach items="${province}" var="p">
							<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
						</c:forEach>
					</form:select>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">城市：</label>
				<div class="controls">
					<form:select id="city" path="city" class="input-xlarge required">
						<form:option value=""></form:option>
						<c:forEach items="${city}" var="c">
							<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
						</c:forEach>
					</form:select>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<script>
				$("#province").change(function(){
					var extId = $("#province").val();
					//extId = encodeURI(extId);
					//异步请求数据
					var url="${ctx}"+"/sys/area/treeData";
					$.get(url,{extId:extId},function(data){
						var content = "<option value=''></option>";
						for(var i in data){
							content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
						}
						$("#city").html(content).trigger("change");
					},"json")
	
				})
			</script>
			<div class="control-group">
				<label class="control-label">街道：</label>
				<div class="controls">
					<form:input path="street" htmlEscape="false" maxlength="500" class="input-xlarge required"/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">所属服务中心：</label>
				<div class="controls">
					<form:select id="orgId" path="orgId" class="input-xlarge required">
						<form:option value=""></form:option>
						<c:forEach items="${fns:getOrgsByType('catRenZheng') }" var="c">
							<form:option value="${fns:escapeHtml(c.id) }">${fns:escapeHtml(c.name) }</form:option>
						</c:forEach>
					</form:select>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<%-- <div class="control-group">
				<label class="control-label">所属服务中心编号：</label>
				<div class="controls">
					<form:input path="orgCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div> --%>
			<div class="control-group">
				<label class="control-label">审核状态：</label>
				<div class="controls">
					<form:select path="reviewState" class="input-xlarge required">
						<form:option value="0">待审核</form:option>
						<form:option value="1">通过</form:option>
						<form:option value="2">未通过</form:option>
					</form:select>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
		</div>
		
		<div class="control-group-head">
			<div class="control-group" style="float: left;width:500px;border-bottom:0px;">
				<label class="control-label">
					认证师照片：
					<span class="help-inline"><font color="red">*</font> </span>
					<label id="photoErr" class="error" style="display:none;">请上传认证师照片</label>
				</label>
				<div class="controls">
					<div style="">
						<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
							<center><img id="previewPhotoImg" alt=""
										 src="${ctx}/sys/file/image/${appraiser.photo}"
										 style="padding:10px;height:130px;"/></center>
							<div style="position:relative;color: #cccccc;font-size: 18px;">
								<center>图片预览</center>
							</div>
						</div>
					</div>
					<div style="">
						<div style="border: 0px dashed #e6e6e6;margin:20px;min-height: 50px;position:relative;">
							<button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
									id="catImgUpload">
								<i class="layui-icon">&#xe67c;</i>上传图片
							</button>
							<form:hidden path="photo" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
						</div>
					</div>
					<script type="text/javascript">
						layui.use('upload', function () {
							var upload = layui.upload;
							//执行实例
							var uploadInst = upload.render({
								elem: '#catImgUpload' //绑定元素
								, url: '${ctx}/sys/file/layupload' //上传接口ctx
								, done: function (res) {//上传完毕回调
									$("#photo").val(res.id);
									$("#previewPhotoImg").attr("src", res.url);
								}
								, error: function () {
									//请求异常回调
								}
							});
						});
					</script>
				</div>
			</div>
		</div>
		<%-- <div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xlarge "/>
			</div>
		</div> --%>
		
		<div style="clear:both;"></div>
		<div class="form-actions">
			<shiro:hasPermission name="sys:appraiser:edit">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>