<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>资格证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/handler/handlerQualificationCertificate/">资格证书列表</a></li>
		<li class="active"><a href="#">资格证书录入</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerQualificationCertificate" action="${ctx}/handler/handlerQualificationCertificate/add" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode"  htmlEscape="false" maxlength="100" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">取证日期：</label>
			<div class="controls">
				<input name="takeCertificateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${handlerQualificationCertificate.takeCertificateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
			<div class="control-group">
			<label class="control-label">审查员：</label>
			<div class="controls">
				<form:select id="reviewer" path="reviewer" class="input-medium " >
	                <form:option value="" label="全部"></form:option>
	                <form:options items="${showRefereeList}" itemLabel="refereeNameCn" itemValue="refereeNameEn" htmlEscape="false"/>
	            </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				<form:select id="certificateLevelEn" path="certificateLevelEn" class="input-medium required" >
	                <form:option value="" label="全部"></form:option>
	                <form:option value="A" label="A"></form:option>
	                <form:option value="B" label="B"></form:option>
	                <form:option value="C" label="C"></form:option>
	                <form:option value="MASTER" label="教师级"></form:option>
	            </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别中文：</label>
			<div class="controls">
				<form:input path="certificateLevelCn" htmlEscape="false" maxlength="64" class="input-xlarge "/>
				<font style="color:red">只有教师级的 需填写'教师' ,其他级别同英文一样</font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				<form:input path="certificateCode"  htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
				<input name="issueDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${handlerQualificationCertificate.issueDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="handler:handlerQualificationCertificate:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>