<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		
			
			var memberCode=$("#memberCode").val();
			$.ajax({
                type:"POST",
                url: ctx+"/groomer/groomerMember/getMemberExperience",
                data : {'memberCode':memberCode},
                dataType: 'json',
                async: false, 
                success: function(json){
                	var html ="";
 					var html1="";
	    			if (json.rc!=1) {
    					html+="<tr><td>"+json.schoolNameCn+"</td><td>"+json.startDate+"</td><td>"+json.endDate+"</td><td>美容师"+
    					json.level+"级</td><td>"+json.code+"</td>";
    					if(json.list.length>0){
	    					$.each(json.list, function(index,item) {
	    						html1+="<tr><td>"+item.showName+"</td><td>"+item.level+"</td><td>"+item.grade+"</td><td>"+
		    					item.referee+"</td><td>"+item.takeDate+"</td><td>"+item.code+"</td>";
		    					$("input[name='code'][type='text']").val(item.code);
		    				});
    					}else{
	    					$("#testDataList").html("<tr>暂无考试经历</tr>");
    					}
	    				$("#trainList").html(html);
    					$("#testDataList").html(html1);
	    			}else{
	    				$("#testDataList").html("暂无考试经历");
	    				$("#trainList").html("暂无培训经历");
	    			}
                }
            });
		});
		
	
		
	</script>
	<%-- <link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/> --%>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerMember/form?id=${member.id}">美容师信息管理</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="member" action="${ctx}/groomer/groomerMember/updateGroomerMember" method="post" class="form-horizontal">
		<form:hidden path="id"/> 
		<form:hidden path="memberCode"/>
		<sys:message content="${message}"/>	
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				${fns:escapeHtml(member.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				${fns:getDictLabels(member.gender,'user_gender','')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<%-- <div class="control-group">
			<label class="control-label">会员开始日期：</label>
			<div class="controls">
				<fmt:formatDate value="${member.startDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div> --%>
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				${fns:escapeHtml(member.cardNo)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				${fns:escapeHtml(member.mobile)}
			</div>
		</div>
		<%-- <div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small">
					<form:option value=""></form:option>
					<c:forEach items="${province}" var="p">
						<form:option value="${fns:escapeHtml(p.id) }">${fns:escapeHtml(p.name) }</form:option>
					</c:forEach>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-small">
					<form:option value=""></form:option>
					<c:forEach items="${city}" var="c">
						<form:option value="${fns:escapeHtml(c.id) }">${fns:escapeHtml(c.name) }</form:option>
					</c:forEach>
				</form:select>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				var extId = $("#province").val();
				//异步请求数据
				var url="${ctx}"+"/sys/area/treeData";
				$.get(url,{extId:extId},function(data){
					var content = "<option value=''></option>";
					for(var i in data){
						content+="<option value='"+data[i].id+"'>"+data[i].name+"</option>"
					}
					$("#city").html(content).trigger("change");
				},"json")
				
			})
		</script> --%>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				${fns:escapeHtml(member.province)}${fns:escapeHtml(member.city)}${fns:escapeHtml(member.street)}
			</div>
		</div>
		<div class="control-group">
				<label class="control-label">培训经历：</label>
				<div class="controls">
					<table id="contentTable" class="table table-striped table-bordered table-condensed">
						<thead>
							<tr>
								<th>学校名称</th>
								<th>开始时间</th>
								<th>结束时间</th>
								<th>培训内容</th>
								<th>证书编号</th>
							</tr>
						</thead>
						<tbody id="trainList">
						</tbody>
					</table>
				</div>
		</div>
		<div class="control-group">
				<label class="control-label">考试经历：</label>
				<div class="controls">
					<table id="contentTable" class="table table-striped table-bordered table-condensed">
						<thead>
							<tr>
								<th>考试名称</th>
								<th>级别</th>
								<th>成绩</th>
								<th>审查员</th>
								<th>取证日期</th>
								<th>证书编号</th>
							</tr>
						</thead>
						<tbody id="testDataList">
						</tbody>
					</table>
				</div>
		</div>
		<div style="clear:both;"></div>
		<h3>美容师信息</h3>
		<div class="control-group">
			<label class="control-label">美容师证书号：</label>
			<div class="controls">
				<input  name="code" type="text" value="无" readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容师类型：</label>
			<div class="controls">
			<input id="groomerType" name="groomerType" value="${fns:getDictLabels(member.groomerType, 'user_groomer_type', '非会员')}" type="text" readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件照：</label>
			<div class="controls">
				<c:choose>
					<c:when test="${not empty member.avatar }">
						<c:if test="${fn:startsWith(member.avatar, 'http')}">
							<img height="170" width="120" src="${member.avatar }">
					     </c:if>
					     <c:if test="${!fn:startsWith(member.avatar, 'http')}">
							<img height="170" width="120" src="${ctx }/sys/file/image/${member.avatar }">
					     </c:if>
					</c:when>
					<c:otherwise>
						暂无图片
					</c:otherwise>
				</c:choose>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
					<input id="groomerEndDate" name="groomerEndDate" type="text" readonly="readonly" maxlength="10" class="input-medium Wdate required"
					value="<fmt:formatDate value="${member.groomerEndDate}" pattern="yyyy-MM-dd"/>"/>
			<shiro:hasPermission name="finance:deductCost:deductCost">
					<c:choose>
						<c:when test="${member.groomerType=='reserve'}">
						<a class="btn btn-primary" onclick="util.pay('${member.id}','sys_member@GR',1,'','${member.memberCode}')">缴费</a>
						</c:when>
						<c:when test="${member.groomerType=='formal'}">
						<a class="btn btn-primary" onclick="util.pay('${member.id}','sys_member@GF',1,'','${member.memberCode}')">缴费</a>
						
						</c:when>
					</c:choose>
			</shiro:hasPermission>
		
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="groomerRemarks" htmlEscape="false"  maxlength="255" class="input-xlarge required"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<shiro:hasPermission name="groomer:groomerMember:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存" />&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>