<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员扣款</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
		function save(){
			var price = $("#price").val();
			var paymentAmount = $("#paymentAmount").val();
			var paymentRemarks = $("#paymentRemarks").val();
			var accountBalance = $("#accountBalance").val();
			if(parseFloat(paymentAmount)<0){
				alert("实扣金额应大于零！");
				return;
			};
			if(parseFloat(paymentAmount)-parseFloat(accountBalance)>0){
				alert("实扣金额应大于会员余额！");
				return;
			}
			if(price!=paymentAmount){
				if(paymentRemarks.replace(/(^\s+)|(\s+$)/g,"").length==0){
					alert("请填写说明！");
					return;
				}
			}
            $("#btnSubmit").attr("disabled",true);
            $("#btnCancel").attr("disabled",true);

			$.ajax({
				type: "POST",
				url:"${ctx}/finance/deductCost/paySave",
				dataType:"json",
				data:$('#inputForm').serialize(),// 你的formid
				async: true,
				error: function(request, textStatus, errorThrown) {
					alert(request.responseText+"请联系管理员！");
				},
				success: function(data) {
					if(data.rc==0){
						alert("扣款成功！");
						parent.isYes = true;
						parent.layer.closeAll();
					}else{
						alert("错误代码："+data.rc+"错误信息："+data.msg);
                        $("#btnSubmit").attr("disabled",false);
                        $("#btnCancel").attr("disabled",false);
					}
				}
			});
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="member" class="form-horizontal">
	<input type="hidden" name="businessId" value="${id }">
	<input type="hidden" name="chargingItemId" value="${payType.id}">
	<div class="control-group">
		<label class="control-label">会员编号：</label>
		<div class="controls">
			<input type="text" readonly="readonly" name="memberCode" value="${memberForm.memberCode}" htmlEscape="false" maxlength="60" class="input-xlarge"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">姓名：</label>
		<div class="controls">
			<input type="text" readonly="readonly" value="${memberForm.name}" htmlEscape="false" maxlength="100" class="input-xlarge"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">会员余额：</label>
		<div class="controls">
			<input type="text" readonly="readonly" id="accountBalance" value="${memberForm.accountBalance}" class="input-xlarge">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">扣费类型：</label>
		<div class="controls">
			<input type="text" readonly="readonly" value="${payType.name}" class="input-xlarge">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">数量：</label>
		<div class="controls">
			<input type="text" readonly name="chargingItemNum" value="${num}" class="input-xlarge">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">应扣金额：</label>
		<div class="controls">
			<c:if test="${price==null}">
				<input type="text" readonly id="price" name="price" value="${payType.price}" class="input-xlarge">
			</c:if>
			<c:if test="${price!=null}">
				<input type="text" readonly id="price" name="price" value="${price}" class="input-xlarge">
			</c:if>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">实扣金额：</label>
		<div class="controls">
			<c:if test="${price==null}">
				<input type="number" step="0.01" min="0" id="paymentAmount" <shiro:lacksPermission name="finance:deductCost:other">readonly</shiro:lacksPermission> name="paymentAmount" value="${payType.price}" placeholder="实扣金额！" class="input-xlarge">
			</c:if>
			<c:if test="${price!=null}">
				<input type="number" step="0.01" min="0" id="paymentAmount"  <shiro:lacksPermission name="finance:deductCost:other">readonly</shiro:lacksPermission> name="paymentAmount" value="${price}" placeholder="实扣金额！" class="input-xlarge">
			</c:if>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">说明：</label>
		<div class="controls">
			<textarea  class="form-control input-xlarge" id="paymentRemarks" name="paymentRemarks"  rows="3" placeholder="请填写说明！"></textarea>
		</div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="button" value="缴费" onclick="save()"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关 闭" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>