<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>配种证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					if($("#malePuppyRegisterNum").val()!=''||$("#femalePuppyRegisterNum").val()!=''){
						if($("#malePuppyRegisterNum").val()==''){
							$("#malePuppyRegisterNum").val(0);
						} else if($("#femalePuppyRegisterNum").val()=='') {
							$("#femalePuppyRegisterNum").val(0);
						}
						$("#dogRegisterNum").val($("#malePuppyRegisterNum").val()+","+$("#femalePuppyRegisterNum").val());
					} else {
						$("#puppyRegisterNum").val('');
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			/*页面初始化根据审核状态控制审核原因显隐*/
			if($("#reviewState").val()==2){
				$("#remarksDiv").show();
			}else {
				$("#remarksDiv").hide();
			}
			/*页面初始化分隔登记数数据并分开展示在页面*/
			var registerNumList = $("#dogRegisterNum").val().split(',');
			if(registerNumList.length>0){
				$("#malePuppyRegisterNum").val(registerNumList[0]);
				$("#femalePuppyRegisterNum").val(registerNumList[1]);
			} else {
				$("#malePuppyRegisterNum").val(0);
                $("#femalePuppyRegisterNum").val(0);
			}
		});
       //改变审核状态控制审核原因显隐
       function changeState(btu){
    	   if(btu.value==2){
    		   $("#remarksDiv").show(); 
    		   $("#reviewRemarks").addClass("required");
    	   } else {
    		   $("#remarksDiv").hide();
    		   $("#reviewRemarks").val('');
    		   $("#reviewRemarks").removeClass("required");
    	   }
       };
       function save(){
    	   $.ajax({
               type: "POST",
               url:"${ctx}/dognewborn/dogNewborn/changeStatus",
               dataType:"json",
               data:$('#inputForm').serialize(),
               async: false,
               error: function(request, textStatus, errorThrown) {
                   alert("系统错误，请联系管理员！");
               },
               success: function(data) {
                   if(data.rc==0){
                	   alert("审核成功");
                       location.href="${ctx}/dognewborn/dogNewborn";
                   }else {
                       alert("错误代码："+data.rc+"错误信息："+data.msg);
                   }
               }
           });
       };
       function searchKin(){
           var fPedigreeCertifiedCode = $("#malePedigreeCertified").val();
           var mPedigreeCertifiedCode = $("#femalePedigreeCertified").val();
           parent.layer.open({
               type: 2,
               title: ['近亲繁殖查询', 'font-size:18px;text-align: center;'],
               shadeClose: false,
               shade: [0.8, '#393D49'],
               maxmin: false, //开启最大化最小化按钮
               area: ['1000px', '600px'],
               content: ctx+"/dog/dog/kinBreedMessage?fPedigreeCertifiedCode="+fPedigreeCertifiedCode+"&mPedigreeCertifiedCode="+mPedigreeCertifiedCode,
               end: function(){
                   
               }
           }); 
       };
       function breedNumber(femalePedigreeCertified){
           $.ajax({
               type:"POST",
               url:"${ctx}/dognewborn/dogNewborn/getBreedNumber",
               data:{
                   femalePedigreeCertified:femalePedigreeCertified
               },
               async: false, 
               success: function(data){
                   var str = eval(data);
                   var date = new Date();
                   var birthday = "";
                   var count = 0;
                   $("#tbody").html('');
                   $("#table").show();
                   $("#count").show();
                   $("#close").show();
                   $.each(str,function(){
                       count++;
                       if(this.birthday!=null&&this.birthday!=''){
                           birthday = util.formatDateShort(this.birthday.time);
                       }else{
                           birthday = "";
                       }
                       $("#tbody").append(
                       "<tr>"+
                       "<td>"+this.breedCertifiedCode+"</td>"+
                       "<td>"+this.area+"</td>"+
                       "<td>"+this.maleDogOwner+"</td>"+
                       "<td>"+this.malePedigreeCertified+"</td>"+
                       "<td>"+this.femaleDogOwner+"</td>"+
                       "<td>"+this.femalePedigreeCertified+"</td>"+
                       "<td>"+util.formatDateShort(this.breedDate.time)+"</td>"+
                       "<td>"+birthday+"</td>"+
                       "<td>"+this.puppyBirthNum+"</td>"+
                       "<td>"+this.reviewState+"</td>"+
                       "</tr>"
                       )
                   });
                   $("#count").text("繁殖次数总计："+count);
               }
          });
       }
       function closeTable(){
           $("#table").hide();
           $("#close").hide();
       };
	</script>
</head>

<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dognewborn/dogNewborn/${'230' eq dogNewborn.dogBreed?'?dogBreed=230':''}">配种证明列表</a></li>
		<li class="active"><a href="${ctx}/dognewborn/dogNewborn/dogNewbornReview?id=${dogNewborn.id}">配种证明<shiro:hasPermission name="dognewborn:dogNewborn:audit">${not empty dogNewborn.id?'审核':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dognewborn:dogNewborn:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogNewborn" action="${ctx}/dognewborn/dogNewborn/changeStatus" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">配种证明编号：</label>
			<div class="controls">
				<form:input path="breedCertifiedCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">犬种类：</label>
            <div class="controls">
                <form:input path="dogBreed" htmlEscape="false" maxlength="10" class="input-xlarge " style="width:40px;" readonly="true"/>&nbsp;
                <form:input path="dogType.dogBreed" htmlEscape="false" class="input-xlarge" readonly="true"/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label" >公犬主人姓名：</label>
			<div class="controls">
				<form:input path="maleDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">公犬主人会员号：</label>
			<div class="controls">
				<form:input path="mdogOwnerCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">母犬主人姓名：</label>
			<div class="controls">
				<form:input path="femaleDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬主人会员号：</label>
			<div class="controls">
				<form:input path="fdogOwnerCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">公犬姓名：</label>
			<div class="controls">
				<form:input path="maleDogName" htmlEscape="false" maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">公犬证书号：</label>
			<div class="controls">
				<form:input path="malePedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">母犬姓名：</label>
			<div class="controls">
				<form:input path="femaleDogName" htmlEscape="false" maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬证书号：</label>
			<div class="controls">
				<form:input path="femalePedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">配种日期：</label>
			<div class="controls">
				<input name="breedDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogNewborn.breedDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});" disabled="disabled"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogNewborn.birthday}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});" disabled="disabled"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">出生数量：</label>
			<div class="controls">
				<form:input path="puppyBirthNum" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记数量：</label>
			<div class="controls">
				<form:hidden path="dogRegisterNum" htmlEscape="false" maxlength="10" class="input-xlarge "/>
				<input id="malePuppyRegisterNum" type="text" class="input-xlarge digits" htmlEscape="false" style="width: 20px;" readonly="true">公
				<input id="femalePuppyRegisterNum" type="text" class="input-xlarge digits"  htmlEscape="false" style="width: 20px;" readonly="true">母
			</div>
		</div>
		<div class="control-group" style="float: left">
            <label class="control-label">加急：</label>
            <div class="controls">
                <form:select path="urgent" class="input-xlarge " style="width: 80px;" disabled="true">
                    <form:option value="" label=""/>
                    <form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">近亲繁殖取DNA：</label>
            <div class="controls">
                <form:checkbox path="kinGetDna"  value="1" class="input-xlarge " disabled="true"/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge " onclick="changeState(this);">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group" id="remarksDiv">
			<label class="control-label">审核的意见：</label>
			<div class="controls">
				<form:input path="reviewRemarks" htmlEscape="false" maxlength="255" class="input-xlarge " />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">审核近亲：</label>
            <div class="controls">
                <input id="" class="btn btn-primary" type="button" value="审查" onclick="searchKin();"/>&nbsp;&nbsp;
                <label>近亲结果：</label>
                <form:select path="kinBreed" class="input-xlarge " style="width: 80px;">
                    <form:option value="" label="请选择"/>
                    <form:options items="${fns:getDictList('kinResults')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>&nbsp;&nbsp;
                <input id="" class="btn btn-primary" type="button" value="审核母犬繁殖次数" onclick="breedNumber('${dogNewborn.femalePedigreeCertified}');"/>&nbsp;&nbsp;
            </div>
        </div>
        <table id="table" class="table table-striped table-bordered table-condensed" style="display:none">
            <thead>
                <tr>
                    <th>配种证明编号</th>
                    <th>所属地区</th>
                    <th>公犬主</th>
                    <th>公犬证书号</th>
                    <th>母犬主</th>
                    <th>母犬证书号</th>
                    <th>配种日期</th>
                    <th>出生日期</th>
                    <th>出生数量</th>
                    <th>审核状态</th>
                </tr>
            </thead>
            <tbody id="tbody">
            </tbody>
            <td colspan="10" style="display:none" id="count"></td>
        </table>
        <input id="close" class="btn" type="button" value="关闭" onclick="closeTable();" style="display:none"/>
		<div class="form-actions">
			<shiro:hasPermission name="dognewborn:dogNewborn:audit"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存" onclick="save();"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
		<div style="height: 50px"></div>
	</form:form>
</body>
</html>