<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>纯种犬鉴定申请</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/dogexport/dogPedigreeCertifiedExport/audit',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("审核成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("审核失败,错误信息："+data.msg);
 						} 
 				    });
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogPedigreeCertifiedExport" class="form-horizontal">
	<form:hidden path="id"/>
	<div class="control-group">
		<label class="control-label">血统证书编号：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.pedigreeCertified)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬种名称：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.breedCnName)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">芯片号码：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.identificationFlag)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬只名称：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.nameEn)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬主姓名：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.dogOwner)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">出生日期：</label>
		<div class="controls">
			<fmt:formatDate value="${dogPedigreeCertifiedExport.birthdate}" pattern="yyyy-MM-dd"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬只毛色：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.colorFlag)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">出口国家：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.exportCountry)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">接收人：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.exporter)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">联系地址：</label>
		<div class="controls">
			${fns:escapeHtml(dogPedigreeCertifiedExport.exportDestination)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">审核状态：</label>
		<div class="controls">
			<c:choose>
				<c:when test="${dogPedigreeCertifiedExport.reviewState=='1'}">
					<form:select id="reviewState" path="reviewState" class="input-medium">
								<option value ="1" selected="selected">通过</option>
								<option value ="3">已注销</option>
					</form:select>	
				</c:when>
				<c:when test="${dogPedigreeCertifiedExport.reviewState=='2'}">
					<form:select id="reviewState" path="reviewState" class="input-medium">
								<option value ="1">通过</option>
								<option value ="2" selected="selected">未通过</option>
								<option value ="3">已注销</option>
					</form:select>	
				</c:when>
				<c:otherwise>
							<form:select id="reviewState" path="reviewState" class="input-medium">
								<option value ="1">通过</option>
								<option value ="2" <c:if test="${dogPedigreeCertifiedExport.reviewState=='2'}">selected="selected"</c:if>>未通过</option>
							</form:select>
				</c:otherwise>
			</c:choose>
		</div>
	</div>
	
			
	<c:if test="${not empty dogPedigreeCertifiedExport.vodUrl }">
		<div  class="control-group" >
			<label class="control-label">犬只视频：</label>
				<div class="controls" height="400px" width="474px" controls>
			<video height="400px" width="474px" controls src="${dogPedigreeCertifiedExport.vodUrl}" > </video>
		   </div>
		</div> 
	</c:if>
	
	<div class="control-group">
		<label class="control-label">审核意见：</label>
		<div class="controls">
			<form:textarea path="reviewRemarks" rows="3" cols="20" class="input-xlarge"/>
		</div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>