<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>犬只DNA存档补寄采样包</title>
<meta name="decorator" content="default" />
<style type="text/css">
	body {
		margin-top: 20px;
	}
	
	.jbox-body .jbox-icon {
		top: 50px !important;
	}
	
	.div-label {
		height: 26px;
		line-height: 26px;
		word-wrap: break-word;
	}
	
	.div-tag {
		color: #d46b08;
		background: #fff7e6;
		min-width: 200px;
		border: 1px solid #ffd591;
		border-radius: 2px;
		text-align: center;
		height: 26px;
		line-height: 26px;
	}
	
	.text-center {
		text-align: center !important;
	}
	
	.div-remark {
		overflow: hidden;
		white-space: nowrap;
		text-overflow: ellipsis;
		width: 170px;
	}
	
	.accordion-heading, .table th {
		white-space: nowrap;
		background-color: white !important;
		background-image: -webkit-linear-gradient(top, white, white) !important;
		background-repeat: repeat-x;
	}
	
	.accordion-heading, .table tr {
		white-space: nowrap;
		background-color: white !important;
		background-image: -webkit-linear-gradient(top, white, white) !important;
		background-repeat: repeat-x;
	}
	
	.form-horizontal .form-actions {
	   padding-left: 0px!important;
	   text-align: center;
	}
</style>
<style>
   .errorMsg{
       height: 500px;
       color: #333;
       margin: auto;
       padding: 1em;
       display: table;
       user-select: none;
       box-sizing: border-box;
       font: lighter 20px "微软雅黑";
   }
   .errorMsg a{
       color: #1ab394;
       text-decoration: none;
   }
   .errorMsg h1{
       margin-top: -20px;
       font-size: 3.5em;
       color:#1ab394;
   }
   .errorMsg .p{
       margin-top: 40px;
       color:red;
       font-weight:700;
   }
   .errorMsg .main{
       margin: 0 auto;
       text-align: center;
       display: table-cell;
       vertical-align: middle;
   }
</style>
<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
</head>
<body>
	<form id="inputForm" action="${ctx}/dogDnaArchive/dogDnaArchiveReissueSampling/orderSave" method="post" class="form-horizontal">
	<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<div class="div-label">${empty dogDnaArchive.pedigreeCertified? '-' : dogDnaArchive.pedigreeCertified}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国外证书号：</label>
			<div class="controls">
				<div class="div-label">${empty dogDnaArchive.overseasPedigreeCertified? '-' : dogDnaArchive.overseasPedigreeCertified}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生纸编号：</label>
			<div class="controls">
				<div class="div-label">${empty dogDnaArchive.birthCode? '-' : dogDnaArchive.birthCode}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
				<div class="div-label">${dogDnaArchive.dogBreed}${not empty dogDnaArchive.breedCnName ? '-':''}${dogDnaArchive.breedCnName}</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				<div class="div-label">${dogDnaArchive.dogName}</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<div class="div-label">
					<fmt:formatDate value="${dogDnaArchive.dogBirthday}" pattern="yyyy-MM-dd" />
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<div class="div-label">${fns:getDictLabel(dogDnaArchive.dogGender, 'dog_gender', '')}</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
				<div class="div-label">
					${dogDnaArchive.dogColorFlag}${not empty dogDnaArchive.dogColorName ? '-':''}${dogDnaArchive.dogColorName}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份标识：</label>
			<div class="controls">
				<div class="div-label">${dogDnaArchive.chipCode}</div>
			</div>
		</div>
		<%-- <div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				<div class="div-label">${dogDnaArchive.memberName}</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">申请日期：</label>
			<div class="controls">
				<div class="div-label">
					<fmt:formatDate value="${dogDnaArchive.createDate}"
						pattern="yyyy-MM-dd HH:mm:ss" />
				</div>
			</div>
		</div> --%>
		<div id="samplingBindRecord" class="control-group" style="padding: 10px 40px;">
			<table id="contentTable" class="table table-striped table-bordered table-condensed">
				<thead>
					<tr>
						<th class="text-center" colspan="4" style="color: #f50; font-size: 14px; padding: 5px;">采样包补寄记录</th>
					</tr>
					<tr>
						<th class="text-center">采样包编号</th>
						<th class="text-center">绑定时间</th>
						<th class="text-center">采样包状态</th>
						<th class="input-medium">备注</th>
					</tr>
				</thead>
				<c:if test="${empty bindSamplingRecord || fn:length(bindSamplingRecord) == 0}">
					<tr>
						<td colspan="4" class="text-center">暂无补寄记录</td>
					</tr>				
				</c:if>
				<c:if test="${not empty bindSamplingRecord && fn:length(bindSamplingRecord) > 0}">
					<c:forEach items="${bindSamplingRecord}" var="sampling">
						<tr>
							<td class="text-center">${sampling.samplingCode}</td>
							<td class="text-center"><fmt:formatDate
									value="${sampling.bindTime}" pattern="yyyy-MM-dd HH:mm:ss" /></td>
							<td class="text-center">
							    <c:choose>
									<c:when test="${sampling.flowState < 2}">
										${fns:getDictLabel(sampling.bindType, 'bind_type', '')}
									</c:when>
									<c:otherwise>
										${fns:getDictLabel(sampling.flowState, 'sampling_flow_state', '')}
									</c:otherwise>
								</c:choose>
							</td>
							<td>
								<div title="${sampling.remarks}" class="div-remark">
									${sampling.remarks}</div>
							</td>
						</tr>
					</c:forEach>
				</c:if>
			</table>
		</div>
		<div class="control-group">
			<label class="control-label">原采样包编号：</label>
			<div class="controls">
				<div class="div-label" style="display: flex;">
					${dogDnaArchiveReissueSampling.oldSamplingCode}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">原采样包备注：</label>
			<div class="controls">
				<div class="div-label">
					${dogDnaArchiveReissueSampling.remarks}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">
				现采样包编号：
			</label>
			<div class="controls">
				<div class="div-label">
					${dogDnaArchiveReissueSampling.samplingCode}
				</div>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="关 闭" onclick="parent.layer.closeAll()" />
		</div>
		
	</form>
</body>
</html>