<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>犬只DNA存档补寄采样包</title>
<meta name="decorator" content="default" />
<style type="text/css">
	body {
		margin-top: 20px;
	}
	
	.jbox-body .jbox-icon {
		top: 50px !important;
	}
	
	.div-label {
		height: 26px;
		line-height: 26px;
		word-wrap: break-word;
	}
	
	.div-tag {
		color: #d46b08;
		background: #fff7e6;
		min-width: 200px;
		border: 1px solid #ffd591;
		border-radius: 2px;
		text-align: center;
		height: 26px;
		line-height: 26px;
	}
	
	.text-center {
		text-align: center !important;
	}
	
	.div-remark {
		overflow: hidden;
		white-space: nowrap;
		text-overflow: ellipsis;
		width: 170px;
	}
	
	.accordion-heading, .table th {
		white-space: nowrap;
		background-color: white !important;
		background-image: -webkit-linear-gradient(top, white, white) !important;
		background-repeat: repeat-x;
	}
	
	.accordion-heading, .table tr {
		white-space: nowrap;
		background-color: white !important;
		background-image: -webkit-linear-gradient(top, white, white) !important;
		background-repeat: repeat-x;
	}
	
	.form-horizontal .form-actions {
	   padding-left: 0px!important;
	   text-align: center;
	}
</style>
<style>
   .errorMsg{
       height: 500px;
       color: #333;
       margin: auto;
       padding: 1em;
       display: table;
       user-select: none;
       box-sizing: border-box;
       font: lighter 20px "微软雅黑";
   }
   .errorMsg a{
       color: #1ab394;
       text-decoration: none;
   }
   .errorMsg h1{
       margin-top: -20px;
       font-size: 3.5em;
       color:#1ab394;
   }
   .errorMsg .p{
       margin-top: 40px;
       color:red;
       font-weight:700;
   }
   .errorMsg .main{
       margin: 0 auto;
       text-align: center;
       display: table-cell;
       vertical-align: middle;
   }
</style>
<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
<script src="${ctxStatic}/vue/vue.js" type="text/javascript"></script>
<script type="text/javascript">
	function loadFun(btnId){
		top.layer.load();
		if(!btnId){
			$("#"+btnId).prop("disabled",true);	
		}
	}
	function closeLoadFun(btnId){
		top.layer.closeAll('loading');
		if(!btnId){
			$("#"+btnId).prop("disabled",false);
		}
	}
	$(document).ready(function() {
		parent.isYes = false;	
		var vueEle = new Vue({
			el:"#inputForm",
			data(){
				return {
					samplingMemberName:'',
					dogDnaArchive: {
						keyword:'',
						bindSamplingRecord:[]
					},
					flowStates:{
						"0":"未绑定",
						"1":"已绑定",
						"2":"已送检",
						"3":"检测成功",
						"4":"失败",
						"5":"已注销"
					}
				}
			},
			methods: {
				formatDate: function(value) {
		            var dt = new Date(value);
		            let year = dt.getFullYear();
		            let month = (dt.getMonth() + 1).toString().padStart(2,'0');
		            let date = dt.getDate().toString().padStart(2,'0');
		            return year+'-'+month+'-'+date;
		        },
				isNull(value) {
					return value == undefined || value == null || value.length == 0;
				},
				isNotNull(value) {
					return value != undefined && value != null && value.length != 0;
				},
				findDnaArchive(){
					var that = this;
					if (that.isNotNull(that.dogDnaArchive.keyword)) {
						loadFun();
						$.ajax({
							type : "GET",
							url : "${ctx}/dogDnaArchive/dogDnaArchiveReissueSampling/findDnaArchive?keyword=" + that.dogDnaArchive.keyword,
							dataType: 'JSON',
							success : function(result) {
								closeLoadFun();
								if (result.rc == 0) {
									that.dogDnaArchive = result.data;
									that.dogDnaArchive.oldSamplingCode = that.dogDnaArchive.samplingCode;
									that.dogDnaArchive.samplingCode = '';
								} else {
									/* $.jBox.error("请输入！", "系统提示"); */
									layer.msg(result.msg);
								}
							},
							error: function (res) {
								closeLoadFun();
								layer.msg("操作失败!");
							}
						});
					} else {
						$.jBox.error("请输入证书号、国外证书号或出生纸编号后查询！", "系统提示");
					}
			    },
			    findBySamplingCode(){
			    	var that = this;
					if (that.isNotNull(that.dogDnaArchive.samplingCode)) {
						loadFun();
						$.ajax({
							type : "GET",
							url : "${ctx}/sampling/sampling/samplingCode?samplingCode=" + that.dogDnaArchive.samplingCode,
							dataType: 'JSON',
							success : function(result) {
								closeLoadFun();
								if (result.rc == 0) {
									if (result.data.bindType == 1) {
										$.jBox.error("请输入已存在且未使用的采样包！", "系统提示");
										that.dogDnaArchive.samplingCode='';
										that.samplingMemberName='';
									} else {
										if(that.isNotNull(result.data.memberName)){
											that.samplingMemberName = result.data.memberName;
										}else{
											that.samplingMemberName = "无";
										}
									}
								} else {
									layer.msg(result.msg);
								}
							},
							error: function (res) {
								closeLoadFun();
								layer.msg("操作失败!");
							}
						});
					} else {
						$.jBox.error("请输入采样包编号后查询！", "系统提示");
					}
			    },
			    reissueSampling(){
			    	var that = this;
					if (that.samplingMemberName == null || that.samplingMemberName == '') {
						$.jBox.error("请先查询采样包归属人！","系统提示");
						return;
					}
					$.jBox.confirm("确认要补寄吗？","系统提示",function(v,h,f){
						if(v=="ok"){
							loadFun('btnSubmit');
							$("#inputForm").ajaxSubmit({
								dataType : 'json',
								beforeSubmit : function() {
									if (!$("#inputForm").valid()|| $(".error:visible").length > 0) {
										return false;
									} else {
										return true;
									}
								},
								success : function(json) {
									closeLoadFun('btnSubmit');
									let data = eval(json);
									if (data.rc == 0) {
										layer.msg(data.data);
										parent.isYes = true;
										parent.layer.closeAll();
									} else {
										layer.msg(data.msg);
									}
								},
								error : function(err) {
									closeLoadFun('btnSubmit');
									layer.msg("操作失败!");
								}
							});
						}
					},{buttonsFocus:1});
					
			    }
		    }
		})
	});

</script>
</head>
<body>
	<form id="inputForm" action="${ctx}/dogDnaArchive/dogDnaArchiveReissueSampling/orderSave" method="post" class="form-horizontal">
		<input type="hidden" name="id" v-model="dogDnaArchive.id"/>
		<input type="hidden" name="paymentMemberCode" value="${paymentMemberCode}"/>
		<input type="hidden" name="paymentChargingItemId" value="${paymentChargingItemId}"/>
		<input type="hidden" name="runningNumber" value="${runningNumber}"/>
		<input type="hidden" name="orderDetailId" value="${orderDetailId}"/>
		
		<div class="control-group">
			<label class="control-label"></label>
			<div class="controls">
				<input type="text" id="keyword" name="keyword" v-model="dogDnaArchive.keyword" maxlength="64" class="input-xlarge" placeholder="请输入血统证书号/国外证书号/出生纸编号"/>
				<button type="button" class="btn btn-primary" v-on:click="findDnaArchive">查询</button>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<div class="div-label">{{dogDnaArchive.pedigreeCertified ? dogDnaArchive.pedigreeCertified : '-'}}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国外证书号：</label>
			<div class="controls">
				<div class="div-label">{{dogDnaArchive.overseasPedigreeCertified ? dogDnaArchive.overseasPedigreeCertified : '-'}}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生纸编号：</label>
			<div class="controls">
				<div class="div-label">{{dogDnaArchive.birthCode ? dogDnaArchive.birthCode : '-' }}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
				<div class="div-label">
					{{dogDnaArchive.dogBreed}} {{dogDnaArchive.breedCnName ? '-':''}} {{dogDnaArchive.breedCnName}}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				<div class="div-label">{{dogDnaArchive.dogName}}</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<div class="div-label">
					{{dogDnaArchive.dogBirthday? formatDate(dogDnaArchive.dogBirthday):''}}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<div class="div-label">
					{{dogDnaArchive.dogGender !=null && dogDnaArchive.dogGender==1 ?'公':''}}
					{{dogDnaArchive.dogGender !=null && dogDnaArchive.dogGender==2 ?'母':''}}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
				<div class="div-label">
					{{dogDnaArchive.dogColorFlag}} {{dogDnaArchive.dogColorName ? '-' + dogDnaArchive.dogColorName:''}}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份标识：</label>
			<div class="controls">
				<div class="div-label">{{dogDnaArchive.chipCode}}</div>
			</div>
		</div>
		<!-- <div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				<div class="div-label">{{dogDnaArchive.memberName}}</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">申请日期：</label>
			<div class="controls">
				<div class="div-label">
					{{dogDnaArchive.createDate}}
				</div>
			</div>
		</div> -->
		<div id="samplingBindRecord" class="control-group" style="padding: 10px 40px;">
			<table id="contentTable" class="table table-striped table-bordered table-condensed">
				<thead>
					<tr>
						<th class="text-center" colspan="4" style="color: #f50; font-size: 14px; padding: 5px;">采样包补寄记录</th>
					</tr>
					<tr>
						<th class="text-center">采样包编号</th>
						<th class="text-center">绑定时间</th>
						<th class="text-center">采样包状态</th>
						<th class="input-medium">备注</th>
					</tr>
				</thead>
				<tr v-if="!dogDnaArchive.bindSamplingRecord || dogDnaArchive.bindSamplingRecord.length == 0">
					<td colspan="4" class="text-center">暂无补寄记录</td>
				</tr>
				<tr v-if="dogDnaArchive.bindSamplingRecord && dogDnaArchive.bindSamplingRecord.length > 0" v-for="sampling in dogDnaArchive.bindSamplingRecord">
					<td class="text-center">{{sampling.samplingCode}}</td>
					<td class="text-center">{{sampling.bindTime}}</td>
					<td class="text-center">{{flowStates[sampling.flowState]}}</td>
					<td>
						<div :title="sampling.remarks" class="div-remark">
							{{sampling.remarks}}
						</div>
					</td>
				</tr>
			</table>
		</div>
		<div class="control-group">
			<label class="control-label">现采样包编号：</label>
			<div class="controls">
				<div class="div-label" style="display: flex;">
					{{dogDnaArchive.oldSamplingCode}}
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">
				<span class="help-inline" style="margin-right:2px;"><font color="red">*</font> </span>
				采样包编号：
			</label>
			<div class="controls">
				<input type="text" name="samplingCode" :disabled="isNull(dogDnaArchive.id)" v-model="dogDnaArchive.samplingCode" class="input-xlarge" maxlength="64" /> 
				<button type="button" :disabled="isNull(dogDnaArchive.id)" class="btn btn-primary" v-on:click="findBySamplingCode">查询</button>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">采样包归属人：</label>
			<div class="controls">
				<div class="div-label" id="samplingMemberNameDiv">{{samplingMemberName}}</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">原采样包备注：</label>
			<div class="controls">
				<textarea name="remarks" v-model="dogDnaArchive.remarks" :disabled="isNull(dogDnaArchive.id)" htmlEscape="false" rows="4" maxlength="255" class="input-xlarge "></textarea>
			</div>
		</div>
		<div class="form-actions" v-show="isNotNull(dogDnaArchive.memberName) && isNotNull(dogDnaArchive.samplingCode)">
			<shiro:hasPermission name="dnaarchive:dogDnaArchive:rebind">
				<input id="btnSubmit" @click="reissueSampling" class="btn btn-primary" type="button" value="保 存" />&nbsp;
			</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="parent.layer.closeAll()" />
		</div>
		
	</form>
</body>
</html>