<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>幼犬信息表管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/pup/pup/">幼犬信息表列表</a></li>
    <shiro:hasPermission name="pup:pup:edit">
        <li><a href="${ctx}/pup/pup/form">幼犬信息表添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="pup" action="${ctx}/pup/pup/" method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>出生纸编号：</label>
            <form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>状态：0未上架；1已上架：</label>
            <form:input path="state" htmlEscape="false" maxlength="2" class="input-medium"/>
        </li>
        <li><label>犬种号：</label>
            <form:input path="dogBreed" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>犬主会员号：</label>
            <form:input path="memberCode" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>配种价格：</label>
            <form:input path="price" htmlEscape="false" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>出生纸编号</th>
        <th>状态：0未上架；1已上架</th>
        <th>犬种号</th>
        <th>犬主会员号</th>
        <th>配种价格</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="pup:pup:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="pup">
        <tr>
            <td><a href="${ctx}/pup/pup/form?id=${pup.id}">
                    ${pup.birthCode}
            </a></td>
            <td>
                    ${pup.state}
            </td>
            <td>
                    ${pup.dogBreed}
            </td>
            <td>
                    ${pup.memberCode}
            </td>
            <td>
                    ${pup.price}
            </td>
            <td>
                <fmt:formatDate value="${pup.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${pup.remarks}
            </td>
            <shiro:hasPermission name="pup:pup:edit">
                <td>
                    <a href="${ctx}/pup/pup/form?id=${pup.id}">修改</a>
                    <a href="${ctx}/pup/pup/delete?id=${pup.id}" onclick="return confirmx('确认要删除该幼犬信息表吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>