package com.cku.schools.mrschool.service;

import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 *user chaixueteng
 *2017年6月22日
 */
@Service
@Transactional(readOnly = true)
public class SchoolsMemberService {
	@Autowired
	private MemberService memberService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	/**
	 * 查询会员信息
	 * @Author chaixueteng
	 * @2016年10月23日下午2:29:05
	 */
	public String checkStudent(String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		if(member==null){
			return "{\"rc\":false,\"msg\":\"查无此会员\"}";
		}else{
			if("1".equals(member.getFreezeFlag())){
				return "{\"rc\":false,\"msg\":\"会员已冻结\"}";
			}
			if ((member.getMemberEndDate() != null && member.getMemberEndDate().getTime() >= new Date().getTime())
					|| (member.getGroomerEndDate() != null && member.getGroomerEndDate().getTime() >= new Date().getTime())) {
				return "{\"rc\":true,\"name\":\"" + member.getName() + "\",\"paymentState\":\"" + "2" + "\"}";
			} else {
				return "{\"rc\":true,\"name\":\"" + member.getName() + "\",\"paymentState\":\"" + "1" + "\"}";
			}
		}
	}
	/**
	 * 合作美容学校会员续费缴费后操作
	 * @Author chaixueteng
	 * @2017年7月10日下午4:24:12
	 */
	@Transactional(readOnly = false)
	public void afterPay(String businessIds) {
		Member member = memberService.get(businessIds);
		String memberCode = member.getMemberCode();
		TrainingInstitution ti = trainingInstitutionDao.getBySchoolMemberCode(memberCode);
		ti.setEndDate(member.getMemberEndDate());
		trainingInstitutionDao.update(ti);
	}

}
