/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v2.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 犬只信息管理Controller
 *
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/cku/v2/dog")
public class CkuDogControllerV2 extends BaseRestController {

	@Autowired
	private RestDogService restDogService;
	/**
	 *
	 * @description: CKU官网根据血统证书号或芯片号进行查询
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午5:26:13
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getByKey(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getByKey(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: CKU官网近亲查询
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午2:09:19
	 */
	@RequestMapping(value = "/bloodline", method = RequestMethod.GET)
	@ResponseBody
	public void bloodline(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.bloodline(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 宠爱王国估值信息查询
	 * @author: Jack Xu
	 * @date: 2016年11月17日 下午11:00:00
	 */
	@RequestMapping(value = "/evaluate", method = RequestMethod.GET)
	@ResponseBody
	public void evaluate(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.evaluate(request);

		ServletUtils.writeResponse(response, result);
	}
}