package com.cku.restful.v1.sys.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.restful.v1.sys.service.RestAppraiserService;
import com.cku.util.ServletUtils;

/**
 * 鉴定师表Controller
 * @author zhangjunwu
 * @version 2019-10-16
 */
@Controller
@RequestMapping(value = "/appraisers")
public class RestAppraiserController extends BaseRestController {

	@Autowired
	private RestAppraiserService restAppraiserService;
	
	@ResponseBody
	@RequestMapping(value = "/{appraiserId}", method = RequestMethod.GET)
    public void getAppraiser(@PathVariable("appraiserId")String appraiserId,HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response,restAppraiserService.getAppraiser(appraiserId));
    }

}