package com.cku.restful.v1.sys.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.entity.ShowOffice;
import com.cku.oa.show.service.ShowOfficeService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.OrgService;
import com.cku.restful.v1.sys.model.RestOrg;
import com.cku.restful.v1.sys.model.RestShowOffice;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.Collator;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Title: com.cku.restful.v1.sys.service
 * Description:
 * Company: cab
 *
 * @author yuanshuai
 * @date 2018/10/16 16:05
 */
@Service
@Transactional(readOnly = true)
public class RestOrgService {

    private final static Comparator<Object> CHINA_COMPARE = Collator.getInstance(java.util.Locale.CHINA);

    @Autowired
    private OrgService orgService;
    @Autowired
    private ShowOfficeService showOfficeService;
    @Autowired
    private OrgDogTypeLimitService orgDogTypeLimitService;

    /**
     * @Description： 获得Org列表
     * @author: yuanshuai
     * @date: 2018/10/16 16:06
     */
    public RESTResponse getList(HttpServletRequest request) {
        String type = request.getParameter("type");
        String displayOnWeb = request.getParameter("displayOnWeb");
        String orgType = request.getParameter("orgType");
        Org find = new Org();
        find.setOrgType(type);
        find.setDisplayOnWeb(displayOnWeb);
        List<Org> list = orgService.findList(find);
        //转为rest
        List<RestOrg> restList = new ArrayList<>();
        for (Org org : list) {
            RestOrg vo = new RestOrg();
            BeanUtil.copyProperties(vo, org, "yyyy-MM-dd");
            vo.setPhone(org.getUser().getPhone());
            vo.setMobile(org.getUser().getMobile());
            if(StringUtils.isBlank(vo.getProvince())){
                continue;
            }
            if("singleTypeClub".equals(type)){
                vo.setOrgDogType(StringUtils.join(orgDogTypeLimitService.findTypeCnByOrgId(org.getId()),","));
            }
            restList.add(vo);
        }
        //按组排序
        Map<String, List<RestOrg>> groupMap = Maps.newHashMap();
        for (RestOrg org : restList) {
            String province = org.getProvince();
            if(StringUtils.isBlank(province)){
                continue;
            }
            if (groupMap.containsKey(province)) {
                groupMap.get(province).add(org);
            } else {
                List<RestOrg> orgList = new ArrayList<>();
                orgList.add(org);
                groupMap.put(province, orgList);
            }
        }
        List<Map<String, Object>> resultList = Lists.newArrayList();
        for (String key : groupMap.keySet()) {
            Map<String, Object> tempMap = Maps.newHashMap();
            tempMap.put("province",key);
            tempMap.put("list",groupMap.get(key));
            resultList.add(tempMap);
        }
        if (orgType != null && orgType.equals("hospital")) {
            List<Org> hospitalList = orgService.findProvince(type);
            for (int i = 0; i < hospitalList.size(); i++) {
                if (hospitalList.get(i) != null && StringUtils.isNotBlank(hospitalList.get(i).getProvince())) {
                    Map<String, Object> tempMap = Maps.newHashMap();
                    tempMap.put("province", hospitalList.get(i).getProvince());
                    tempMap.put("list", null);
                    if (!groupMap.containsKey(hospitalList.get(i).getProvince())) {
                        resultList.add(tempMap);
                    }
                }
            }
        }

        //按省份排序
        resultList.sort((o1, o2) -> CHINA_COMPARE.compare(o1.get("province"),o2.get("province")));
        return new RESTResponse("data", resultList);
    }

    /**
     * @Description： 获取地方办公室列表
     * @author: yuanshuai
     * @date: 2018/12/18 10:03
     */
    public RESTResponse getOfficeList(HttpServletRequest request) {
        ShowOffice find = new ShowOffice();
        List<ShowOffice> list = showOfficeService.findList(find);
        //转为rest
        List<RestShowOffice> restList = new ArrayList<>();
        for (ShowOffice office : list) {
            RestShowOffice vo = new RestShowOffice();
            BeanUtil.copyProperties(vo, office, "yyyy-MM-dd");
            restList.add(vo);
        }
        return new RESTResponse("data", restList);
    }

    public RESTResponse orgList(HttpServletRequest request, HttpServletResponse response) {
        String orgType = request.getParameter("orgType");
        String name = request.getParameter("name");
        String orgSite = request.getParameter("orgSite");
        String province = request.getParameter("province");
        String pageSize = request.getParameter("pageSize");
        String pageNo = request.getParameter("pageNo");
        Integer pageSizeInt = null;
        Integer pageNoInt = null;
        if (StringUtils.isNotBlank(pageSize)) {
            try {
                pageSizeInt = Integer.valueOf(pageSize);
                pageNoInt = Integer.valueOf(pageNo);
            } catch (Exception e) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
                        "pageSize必须为整数");
            }
        }
        Org find = new Org();
        find.setOrgType(orgType);
        find.setProvince(province);
        find.setName(name);
        find.setOrgSite(orgSite);
        find.setState("0");
        find.setDisplayOnWeb("1");
        Page<Org> page = new Page<Org>(request, response);
        page.setPageNo(pageNoInt);
        page.setPageSize(pageSizeInt);
//        page.setOrderBy("a.create_date DESC");
        Page<Org> orgPage = orgService.findPage(page, find);
        List<Map<String ,Object>> resultList = orgPage.getList().stream().map(data->{
            Map<String ,Object> map =new HashMap<String ,Object>();
            map.put("name",data.getName());
            map.put("province",data.getProvince()+data.getCity());
            map.put("tel",data.getTel());
            map.put("address",data.getAddress());
            map.put("orgSite", DictUtils.getDictLabels(data.getOrgSite(), "org_site", "CKU").replace(",","/"));
            map.put("displayOnWeb",data.getDisplayOnWeb());
            if("singleTypeClub".equals(data.getOrgType())){
                map.put("orgType","单犬种合作机构");
            }else {
                map.put("orgType",DictUtils.getDictLabel(data.getOrgType(), "sys_org_type", ""));
            }
            return map;
        }).collect(Collectors.toList());

        return new RESTResponse("data", resultList);
    }
}
