/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.model;

import com.cku.oa.show.entity.ShowJudge;
import com.cku.oa.sys.util.ImgUtil;

import javax.servlet.http.HttpServletRequest;

/**
 * 赛事裁判Entity
 *
 * @author lgl
 * @version 2016-08-20
 */
public class RestShowJudge {

    private String judgeName;        // 裁判姓名
    private String judgePicture;		// 裁判图片
    private String citizenship;        // 裁判国籍
    private String introduce;        // 裁判介绍
    private String judgeTitle;        // 裁判头衔
    private String judgeTitleShort;        // 头衔缩写

    public RestShowJudge(ShowJudge po,HttpServletRequest request){
        this.judgeName = getString(po.getJudgeName());
        this.judgePicture = ImgUtil.getImgUrl(request,po.getJudgePicture());
        this.citizenship = getString(po.getCitizenship());
        this.introduce = getString(po.getIntroduce());
        this.judgeTitle = getString(po.getJudgeTitle());
        this.judgeTitleShort = getString(po.getJudgeTitleShort());
    }

    public RestShowJudge(String judgeName,String judgePicture,String citizenship,String introduce,String judgeTitle,String judgeTitleShort){
        this.judgeName = getString(judgeName);
        this.judgePicture = getString(judgePicture);
        this.citizenship = getString(citizenship);
        this.introduce = getString(introduce);
        this.judgeTitle = getString(judgeTitle);
        this.judgeTitleShort = getString(judgeTitleShort);
    }
    public String getJudgeName() {
        return judgeName;
    }

    public void setJudgeName(String judgeName) {
        this.judgeName = judgeName;
    }

    public String getJudgePicture() {
        return judgePicture;
    }

    public void setJudgePicture(String judgePicture) {
        this.judgePicture = judgePicture;
    }

    public String getCitizenship() {
        return citizenship;
    }

    public void setCitizenship(String citizenship) {
        this.citizenship = citizenship;
    }

    public String getIntroduce() {
        return introduce;
    }

    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }

    public String getJudgeTitle() {
        return judgeTitle;
    }

    public void setJudgeTitle(String judgeTitle) {
        this.judgeTitle = judgeTitle;
    }

    public String getJudgeTitleShort() {
        return judgeTitleShort;
    }

    public void setJudgeTitleShort(String judgeTitleShort) {
        this.judgeTitleShort = judgeTitleShort;
    }

    private static String getString(String str){
        return str==null?"":str;
    }
}