/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.handler.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.handler.service.RestHandlerShowService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 活动Controller
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Api(value = "牵犬活动报名-xuxue", tags = { "牵犬活动报名-xuxue" })
@Controller
@RequestMapping(value = "/api/v1/handler")
public class RestHandlerShowController extends BaseRestController {

	@Autowired
	private RestHandlerShowService restHandlerShowService;

	@ApiOperation(value = "牵犬活动报名-列表", notes = "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"list\": [\n" + "        {\n" + "            \"topicImage\": \"\",\n"
			+ "            \"showName\": \"2020年CKU牵犬师资格认证考试-西安\",\n"
			+ "            \"testLevel\": \"C\",   -- 修改字段，当返回值有none时，返回\"\"\n" + "            \"fee\": \"300.00\",\n"
			+ "            \"hotelId\": \"\",\n" + "            \"referee\": \"29\",\n"
			+ "            \"showCode\": \"202004-西安-C\",\n" + "            \"showAddress\": \"西安\",\n"
			+ "            \"registerImage\": \"\",\n" + "            \"reviewImage\": \"\",\n"
			+ "            \"venueId\": \"\",\n" + "            \"showType\": \"牵犬师考试-C\",\n"
			+ "            \"registerEndTime\": \"2020-06-26 18:46\",\n"
			+ "            \"startTime\": \"2020-06-06 00:00:00\",\n"
			+ "            \"endTime\": \"2020-06-07 00:00:00\",\n"
			+ "            \"id\": \"dac898f0762d4194a82b73dc7de3fe54\",\n"
			+ "            \"canRegister\": true  -- 是否可以报名\n" + "        }\n" + "    ],\n" + "    \"total\": 68\n"
			+ "}\n" + ""))
	@RequestMapping(value = "/handlerShow", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restHandlerShowService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "审查员-列表", notes = "")
	@RequestMapping(value = "/examiner/list", method = RequestMethod.GET)
	@ResponseBody
	public void getExaminerList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restHandlerShowService.getExaminerList(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "训犬师活动报名-列表", notes = "")
	@RequestMapping(value = "/handlerShow/trainer/list", method = RequestMethod.GET)
	@ResponseBody
	public void getTrainerList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restHandlerShowService.getTrainerList(request);
		ServletUtils.writeResponse(response, result);
	}
	

	
	
 
	
}