package com.cku.restful.v1.groomer.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.groomer.service.GroomerShowService;
import com.cku.oa.groomer.utils.GroomerUtil;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.restful.v1.cab.groomer.model.RestGroomerShowReferee;
import com.cku.restful.v1.groomer.model.RestGroomerShow;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 美容师活动Service
 *
 * @author cxt
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)
public class RestGroomerShowService {
	@Autowired
	private GroomerShowService groomerShowService;
	@Autowired
	private GroomerShowRefereeService showRefereeService;
	@Autowired
	private GroomerRegisterService groomerRegisterService;

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids) {
		GroomerRegister gr = new GroomerRegister();
		gr.setDelFlag("0");
		gr.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		gr.setId(ids);
		List<GroomerRegister> lgr = groomerRegisterService.findList(gr);
		StringBuffer sb = new StringBuffer();
		lgr.stream().forEach(i -> sb.append("'" + i.getShowCode() + "'").append(","));
		if (sb.length() > 0)
			sb.deleteCharAt(sb.length() - 1);
		List<RestGroomerShow> list = new ArrayList<>();
		if (StringUtils.isNotEmpty(sb)) {
			GroomerShow example = new GroomerShow();
			example.setDelFlag("0");
			example.setId(String.valueOf(sb));
			List<GroomerShow> groomerShowList = groomerShowService.findList(example);
			for (GroomerShow groomerShow : groomerShowList) {
				RestGroomerShow vo = new RestGroomerShow();
				vo.setReviewStateCode("0");
				BeanUtil.copyProperties(vo, groomerShow, "yyyy-MM-dd HH:mm");
				vo.setShowType(DictUtils.getDictLabel(vo.getShowType(), "groomer_show_type", ""));
				vo.setId(lgr.stream().filter(i -> i.getShowCode().equals(vo.getShowCode())).findFirst().get().getId());
				list.add(vo);
			}
		}
		return new RESTResponse("data", list);
	}

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String showType = request.getParameter("showType");
		String showName = request.getParameter("showName");
		String showAddress = request.getParameter("showAddress");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String recommend = request.getParameter("recommend");// 宠爱王国app推荐
		String canRegister = request.getParameter("canRegister");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		GroomerShow example = new GroomerShow();
		// 设置分页参数
		Page<GroomerShow> page = new Page<GroomerShow>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 1. 可以报名的比赛 2. 活动时间最近 3. 活动发布时间最新
		page.setOrderBy("a.register_end_time>now()  desc,ABS(a.start_time-now()),a.create_date desc ");
		// 设置查询条件
		example.setPage(page);
		example.setDelFlag("0");
		example.setOneYear(true);
		if(StringUtils.isNotBlank(canRegister) && Boolean.valueOf(canRegister)) {
			example.setRegisterEndTime(new Date());
		}
		if (StringUtils.isNotBlank(showType)) {
			example.setShowType(showType);
		}
		if (StringUtils.isNotBlank(showName)) {
			example.setShowName(showName);
		}
		if (StringUtils.isNotBlank(showAddress)) {
			example.setShowAddress(showAddress);
		}
		if (StringUtils.isNotBlank(recommend)) {
			example.setRecommend(recommend);
		}
		/**
		 * update by zhangjunwu 修改分页错误问题，将过滤数据逻辑加入查询语句，防止下面过滤数据，导致的分页错误
		 */
		example.setExcludeType("团体挑战赛");
		example.setExcludeCode("CQ");
		example.setRegisterType("app");
		
		// 查询并组装返回对象
		Page<GroomerShow> result = groomerShowService.findPage(page, example);
		List<GroomerShow> groomerShowList = result.getList();
		List<RestGroomerShow> list = new ArrayList<RestGroomerShow>();
		for (GroomerShow groomerShow : groomerShowList) {
			RestGroomerShow vo = new RestGroomerShow();
			BeanUtil.copyProperties(vo, groomerShow, "yyyy-MM-dd HH:mm");
			vo.setShowType(DictUtils.getDictLabel(vo.getShowType(), "groomer_show_type", ""));
			vo.setTopicImage(ImgUtil.getImgUrl(request, vo.getTopicImage()));
			vo.setRegisterImage(ImgUtil.getImgUrl(request, vo.getRegisterImage()));
			vo.setTestLevel(transform(vo.getTestLevel()));
			vo.setCanRegister(groomerShow.getRegisterEndTime().after(new Date()));
			//活动头图
			if(StringUtils.isNotBlank(groomerShow.getShowPhoto())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+groomerShow.getShowPhoto();
				vo.setShowPhoto(imgPath);
			}
			//活动分类
			//级别
			if("2".equals(vo.getShowCategory())){
				vo.setShowTypeSpare(new String[]{"国际宠物美容师"});
			}
			if("3".equals(vo.getShowCategory())){
				vo.setShowTypeSpare(new String[]{"国际宠物美容师","宠物造型师&国际宠物美容师"});
			}
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestGroomerShow>(list, count));
	}

	/**
	 * @Description：美容或培训裁判信息查询
	 * @author: zhuoHeng
	 * @version: 2016年11月23日 下午3:09:37
	 */
	public RESTResponse getRefereeList(HttpServletRequest request) {
		String ids = request.getParameter("ids");
		if (StringUtils.isBlank(ids)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数缺失裁判id");
		}
		String[] strs = ids.split(",");
		StringBuffer sb = new StringBuffer();
		for (String id : strs) {
			sb.append("'");
			sb.append(id);
			sb.append("',");
		}
		ids = sb.substring(0, sb.length() - 1);
		List<RestGroomerShowReferee> list = showRefereeService.getRefereeList(ids);

		String path = request.getContextPath();
		for (RestGroomerShowReferee restList : list) {
			if(StringUtils.isNotBlank(restList.getRefereePicture())){
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+restList.getRefereePicture();
				restList.setRefereePicture(imgPath);
			}
			//裁判名称转unicode，前端展示用
			if(StringUtils.isNotBlank(restList.getRefereeNameCn())){
				restList.setRefereeNameCn(StringEscapeUtils.unescapeHtml4(restList.getRefereeNameCn()));
			}
		}

		long count = list.size();
		return new RESTResponse("list", new PageBeanResult<RestGroomerShowReferee>(list, count));
	}

	// none,C,B,A,MASTER
	private String transform(String a) {
		if ("none".equals(a)) {
			return null;
		}
		StringBuffer sb = new StringBuffer();
		String[] arr = a.split(",");
		GroomerUtil.sort(new ArrayList<>(Arrays.asList(arr)));
		
		for (int i = 0; i < arr.length; ++i) {
			if (!"none".equals(arr[i])) {
				sb.append(GroomerUtil.transLevel( arr[i]));
				sb.append('/');
			}
			
		}
		return sb.subSequence(0, sb.length() - 1).toString();
	}

}