package com.cku.restful.v1.finance.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.finance.service.RestPaymentChargingItemService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value = "/api/v1/chargingItem")
public class RestPaymentChargingItemController extends BaseRestController {
	@Autowired
	private RestPaymentChargingItemService restPaymentChargingItemService;

	/**
	 * 
	 * @Description：根据shortName获取收费项
	 * @author: zhuoHeng
	 * @version: 2016年12月7日 上午10:11:06
	 */
	@RequestMapping(value = "/chargingItem", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String shortName = request.getParameter("shortName");
		RESTResponse result = restPaymentChargingItemService.get(shortName);
		ServletUtils.writeResponse(response, result);
	}
}