package com.cku.restful.v1.dog.web;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.restful.v1.dog.service.RestDogOwnerChangeService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.CacheUtils;

/**
 * 犬主变更申请Controller
 *
 * @author zhuoHeng
 * @version 2016-08-17
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogOwnerChangeController extends BaseRestController {

	@Autowired
	private RestDogOwnerChangeService restDogOwnerChangeService;
	@Autowired
	private SMSRemindService smsRemindService;
	private static final String NEW_CACHE_NAME = "newSmsCache";

	@RequestMapping(value = "/dogownerchange", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogOwnerChangeService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogownerchange/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void delete(@PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogOwnerChangeService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogownerchange", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogOwnerChangeService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogownerchange", method = RequestMethod.PUT)
	@ResponseBody
	public void put(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogOwnerChangeService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogownerchange/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogOwnerChangeService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：获取犬主变更申请详细信息（宠爱王国使用）
	 * @author: zhuoHeng
	 * @version: 2016年12月27日 下午2:35:10
	 */
	@RequestMapping(value = "/dogownerchange/cab", method = RequestMethod.GET)
	@ResponseBody
	public void delete(HttpServletRequest request,HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogOwnerChangeService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月5日 下午4:27:40
	 */
	@RequestMapping(value = "/dogownerchange/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogOwnerChangeService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：订单详细中发送验证码
	 * @author: cuihuaiyu
	 * @version: 2018年1月03日 下午14:38
	 */
	@RequestMapping(value="/sms/{method}" , method=RequestMethod.GET)
	@ResponseBody
	public void getSmsCode(@PathVariable String method,HttpServletRequest request,HttpServletResponse response) throws IOException{
		smsRemindService.sendCodeMessage(method,request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 *
	 * @Description：获取当前订单详细中发送验证码的到期时间
	 * @author: cuihuaiyu
	 * @version: 2018年1月03日 下午14:38
	 */
	@RequestMapping(value = "/getCacheTime", method = RequestMethod.GET)
	@ResponseBody
	public void getCacheTime(HttpServletRequest request,HttpServletResponse response) throws IOException{
		String id = request.getParameter("id");
		int time = 0;
		Date date = (Date)CacheUtils.get(NEW_CACHE_NAME,"newSmsDate"+id);
		if(date!=null){
			time = (int) (60-(System.currentTimeMillis()-date.getTime())/1000);
		}
		Map<String, Integer> map = new 	HashMap<>();
		map.put("time", time<0?0:time);
		ServletUtils.writeResponse(response, new RESTResponse("data",map));
	}
}