package com.cku.restful.v1.cab.groomer.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.service.RestGroomerShowService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:CabGroomerShowController </p>
 * <p>Description:美容师活动列表 </p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年11月8日 下午12:13:04
 */
@Controller
@RequestMapping(value = "/api/v1/open/groomer")
public class CabGroomerShowController extends BaseRestController {
	@Autowired
	private RestGroomerShowService restGroomerShowService;

	/**
	 * 
	 * @Description：美容活动数据
	 * @author: zhuoHeng
	 * @version: 2016年11月8日 下午5:26:48
	 */
	@RequestMapping(value = "/groomerShow", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restGroomerShowService.getList(request);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：美容或培训裁判信息查询
	 * @author: zhuoHeng
	 * @version: 2016年11月23日 下午3:08:04
	 */
	@RequestMapping(value = "/referee", method = RequestMethod.GET)
	@ResponseBody
	public void getRefereeList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restGroomerShowService.getRefereeList(request);
		ServletUtils.writeResponse(response, result);
	}
	
}