package com.cku.restful.v1.breeder.web;

import com.cku.restful.v1.breeder.service.RestPupService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @description: 幼犬
 * @author: laiguanglong
 * @date: 2017/10/9 9:56
 */
@Controller
@RequestMapping(value = "/api/v1/breeder/pup")
public class RestPupController extends BaseRestController {

    @Autowired
    private RestPupService service;

    /**
     * @description: 我的幼犬列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public void getMyPup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.getMyPup(request));
    }

    /**
     * @description: 保存幼犬信息并上架接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "", method = RequestMethod.POST)
    public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.post(json));
    }

    /**
     * @description: 编辑幼犬信息
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "", method = RequestMethod.PUT)
    public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.put(json));
    }

    /**
     * @description: 幼犬状态变更接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "/pupState", method = RequestMethod.PUT)
    public void pupState(@RequestBody String json, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.pupState(json));
    }

    /**
     * @description: 我的可申请幼犬的出生纸列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "getCanApplyPupList", method = RequestMethod.GET)
    public void getCanApplyPupList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.getCanApplyPupList(request));
    }

    /**
     * @description: 我的可申请幼犬的出生纸犬种列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "getCanApplyPupDogBreedList", method = RequestMethod.GET)
    public void getCanApplyPupDogBreedList(HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.getCanApplyPupDogBreedList());
    }

    /**
     * @description: 标签接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "/label", method = RequestMethod.GET)
    public void label(HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.label());
    }

}