package com.cku.restful.v1.appreciation.model;

import java.io.Serializable;

import javax.validation.constraints.Pattern;

import org.hibernate.validator.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@Validated
@ApiModel
public class RestAppreciationApply implements Serializable {

	private static final long serialVersionUID = 3513747895837991920L;

	@ApiModelProperty(value = "报名人真实姓名")
	@NotBlank(message = "姓名不能为空")
	private String realName;

	@ApiModelProperty(value = "所在省")
	@NotBlank(message = "省不能为空")
	private String province;

	@ApiModelProperty(value = "所在市")
	@NotBlank(message = "市不能为空")
	private String city;

	@ApiModelProperty(value = "所在区")
	@NotBlank(message = "区不能为空")
	private String area;

	@ApiModelProperty(value = "所在街道")
	private String street;

	@ApiModelProperty(value = "手机号")
	@NotBlank(message = "手机号不能为空")
	@Pattern(regexp = "^[1]{1}[0-9]{10}$", message = "手机号校验未通过")
	private String mobile;
	
	@ApiModelProperty("店名")
	@NotBlank(message = "店名不能为空")
	private String shopName;
	
	@ApiModelProperty("0正常 1试听")
	@NotBlank(message = "报名方式未传入！")
	private String applyType;
	
	@ApiModelProperty("验证码")
	@NotBlank(message = "验证码不能为空！")
	private String smsCode;
	

	@ApiModelProperty("openId")
	@NotBlank(message = "openId不能为空！")
	private String openId;
	
	

}
