package com.cku.oa.tongjis.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.tongjis.entity.Caiwu;
import com.cku.oa.tongjis.service.CaiwuService;

/**
 * tongjisController
 * @author zfx
 * @version 2019-08-26
 */
@Controller
@RequestMapping(value = "${adminPath}/tongjis/caiwu")
public class CaiwuController extends BaseController {

	@Autowired
	private CaiwuService caiwuService;
	
	@ModelAttribute
	public Caiwu get(@RequestParam(required=false) String id) {
		Caiwu entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = caiwuService.get(id);
		}
		if (entity == null){
			entity = new Caiwu();
		}
		return entity;
	}
	
	@RequiresPermissions("tongjis:caiwu:view")
	@RequestMapping(value = {"list", ""})
	public String list(Caiwu caiwu, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Caiwu> page = caiwuService.findPage(new Page<Caiwu>(request, response), caiwu); 
		model.addAttribute("page", page);
		return "oa/tongjis/caiwuList";
	}

	@RequiresPermissions("tongjis:caiwu:view")
	@RequestMapping(value = "form")
	public String form(Caiwu caiwu, Model model) {
		model.addAttribute("caiwu", caiwu);
		return "oa/tongjis/caiwuForm";
	}

	@RequiresPermissions("tongjis:caiwu:edit")
	@RequestMapping(value = "save")
	public String save(Caiwu caiwu, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, caiwu)){
			return form(caiwu, model);
		}
		caiwuService.save(caiwu);
		addMessage(redirectAttributes, "保存统计成功");
		return "redirect:"+Global.getAdminPath()+"/tongjis/caiwu/?repage";
	}
	
	@RequiresPermissions("tongjis:caiwu:edit")
	@RequestMapping(value = "delete")
	public String delete(Caiwu caiwu, RedirectAttributes redirectAttributes) {
		caiwuService.delete(caiwu);
		addMessage(redirectAttributes, "删除统计成功");
		return "redirect:"+Global.getAdminPath()+"/tongjis/caiwu/?repage";
	}

}