package com.cku.oa.sys.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.apache.commons.lang3.StringUtils;

/**
 * 密码强度校验工具类
 * @author fanhuibin
 *
 */
public class CheckPswUtil {
	
	/**
	 * 系统管理员的密码强度规范
	 * 1.密码长度最少8位
	 * 2.分数最少30分
	 * 3.最少需要一个数字或者其他特殊字符
	 * @param password
	 * @return 错误消息的集合，为0则为成功
	 */
	public static List<String> checkManagerPassword(String password){
		List<String> errorMessage = new ArrayList<String>();
		CheckPswMeter checker = new CheckPswMeter(password);
		if(checker.getLength() < 8){
			errorMessage.add("密码的长度过短，最少需要8位字符");
		}
		if(checker.getScore() < 30){
			errorMessage.add("密码的强度过低,可以混合数字、大写字符提高密码复杂度");
		}
		if(!(checker.getUpperAlp() > 0 || checker.getNum() > 0  || checker.getCharlen() > 0)){
			errorMessage.add("密码必须包含大写字母、数字或特殊字符中的一项");
		}
		return errorMessage;
	}
	
	/**
	 * 普通会员的密码校验
	 * 规则：长度大于8，分数最少15分。
	 * @param password
	 * @return
	 */
	public static boolean checkMemberPassword(String password){
		List<String> errorMessage = new ArrayList<String>();
		CheckPswMeter checker = new CheckPswMeter(password);
		if(checker.getLength() < 8){
			return false;
		}
		if(checker.getScore() < 15){
			return false;
		}
		return true;
	}
	
	/**
	 * 验证是否纯数字
	 * @param str
	 * @return
	 */
	public static boolean isNumeric(String str) {
		if (StringUtils.isEmpty(str)) {
			return Boolean.TRUE;
		}
		char[] chars = str.toCharArray();
		for (char c : chars) {
			if (!Character.isDigit(c)) {
				return Boolean.FALSE;
			}
		}
		return Boolean.TRUE;
	}

	/**
	 * 验证是否 连续数字或字符
	 * @param str 数字或字符
	 * @param digit 验证位数
	 * @return
	 */
	public static boolean isConsecutive(String str, int digit) {
		if (StringUtils.isEmpty(str) || digit < 0) {
			return Boolean.TRUE;
		}
		char[] chars = str.toCharArray();
		for (int i = 5; i < chars.length; i++) {
			boolean isConsecutive = Boolean.TRUE;
			for (int j = i - 5; j < i; j++) {
				if (!Character.isLetterOrDigit(chars[j]) || chars[j] != chars[j + 1] - 1) {
					isConsecutive = Boolean.FALSE;
					break;
				}
			}
			if (isConsecutive) {
				return Boolean.TRUE;
			}
		}
		return Boolean.FALSE;
	}

	/**
	 * 验证是否 重复数字或字符
	 * @param str 数字或字符
	 * @param digit 验证位数
	 * @return
	 */
	public static boolean hasRepeatedConsecutiveChars(String str, int digit) {
		if (StringUtils.isEmpty(str) || digit < 0) {
			return Boolean.TRUE;
		}
		char[] chars = str.toCharArray();
		for (int i = 5; i < chars.length; i++) {
			boolean isRepeated = Boolean.TRUE;
			for (int j = i - 5; j < i; j++) {
				if (!Character.isLetterOrDigit(chars[j]) || chars[j] != chars[i]) {
					isRepeated = Boolean.FALSE;
					break;
				}
			}
			if (isRepeated) {
				return Boolean.TRUE;
			}
		}
		return Boolean.FALSE;
	}

	public static String generateRandomString(int digit) {
		if (digit < 0) {
			digit = 8;
		}
		String characters = "ABCDEFGHJKMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxyz123456789";
		StringBuilder sb = new StringBuilder(digit);
		Random random = new Random();
		for (int i = 0; i < digit; i++) {
			int index = random.nextInt(characters.length());
			sb.append(characters.charAt(index));
		}
		return sb.toString();
	}
	
}
